/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import io.trino.hadoop.$internal.org.apache.commons.io.IOUtils;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.CacheStats;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MemoryMappedBlock;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryMappableBlockLoader
extends MappableBlockLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMappableBlockLoader.class);
    private CacheStats memCacheStats;

    @Override
    CacheStats initialize(DNConf dnConf) throws IOException {
        LOG.info("Initializing cache loader: MemoryMappableBlockLoader.");
        this.memCacheStats = new CacheStats(dnConf.getMaxLockedMemory());
        return this.memCacheStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    MappableBlock load(long length, FileInputStream blockIn, FileInputStream metaIn, String blockFileName, ExtendedBlockId key) throws IOException {
        MemoryMappedBlock mappableBlock = null;
        MappedByteBuffer mmap = null;
        FileChannel blockChannel = null;
        try {
            blockChannel = blockIn.getChannel();
            if (blockChannel == null) {
                throw new IOException("Block InputStream has no FileChannel.");
            }
            mmap = blockChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            NativeIO.POSIX.getCacheManipulator().mlock(blockFileName, mmap, length);
            this.verifyChecksum(length, metaIn, blockChannel, blockFileName);
            mappableBlock = new MemoryMappedBlock(mmap, length);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)blockChannel);
            if (mappableBlock == null && mmap != null) {
                NativeIO.POSIX.munmap(mmap);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)blockChannel);
        if (mappableBlock == null && mmap != null) {
            NativeIO.POSIX.munmap(mmap);
        }
        return mappableBlock;
    }

    @Override
    public long getCacheUsed() {
        return this.memCacheStats.getCacheUsed();
    }

    @Override
    public long getCacheCapacity() {
        return this.memCacheStats.getCacheCapacity();
    }

    @Override
    long reserve(ExtendedBlockId key, long bytesCount) {
        return this.memCacheStats.reserve(bytesCount);
    }

    @Override
    long release(ExtendedBlockId key, long bytesCount) {
        return this.memCacheStats.release(bytesCount);
    }

    @Override
    public boolean isTransientCache() {
        return true;
    }

    @Override
    public MappableBlock getRecoveredMappableBlock(File cacheFile, String bpid, byte volumeIndex) throws IOException {
        return null;
    }

    @Override
    public boolean isNativeLoader() {
        return false;
    }
}

