/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.trino.hadoop.$internal.org.apache.commons.codec.binary.Hex;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class EditsDoubleBuffer {
    protected static final Logger LOG = LoggerFactory.getLogger(EditsDoubleBuffer.class);
    private TxnBuffer bufCurrent;
    private TxnBuffer bufReady;
    private final int initBufferSize;

    public EditsDoubleBuffer(int defaultBufferSize) {
        this.initBufferSize = defaultBufferSize;
        this.bufCurrent = new TxnBuffer(this.initBufferSize);
        this.bufReady = new TxnBuffer(this.initBufferSize);
    }

    public void writeOp(FSEditLogOp op, int logVersion) throws IOException {
        this.bufCurrent.writeOp(op, logVersion);
    }

    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        this.bufCurrent.write(bytes, offset, length);
    }

    public void close() throws IOException {
        Preconditions.checkNotNull(this.bufCurrent);
        Preconditions.checkNotNull(this.bufReady);
        int bufSize = this.bufCurrent.size();
        if (bufSize != 0) {
            this.bufCurrent.dumpRemainingEditLogs();
            throw new IOException("FSEditStream has " + bufSize + " bytes still to be flushed and cannot be closed.");
        }
        IOUtils.cleanupWithLogger(null, this.bufCurrent, this.bufReady);
        this.bufReady = null;
        this.bufCurrent = null;
    }

    public void setReadyToFlush() {
        assert (this.isFlushed()) : "previous data not flushed yet";
        TxnBuffer tmp = this.bufReady;
        this.bufReady = this.bufCurrent;
        this.bufCurrent = tmp;
    }

    public void flushTo(OutputStream out) throws IOException {
        this.bufReady.writeTo(out);
        this.bufReady.reset();
    }

    public boolean shouldForceSync() {
        return this.bufCurrent.size() >= this.initBufferSize;
    }

    DataOutputBuffer getReadyBuf() {
        return this.bufReady;
    }

    DataOutputBuffer getCurrentBuf() {
        return this.bufCurrent;
    }

    public boolean isFlushed() {
        return this.bufReady.size() == 0;
    }

    public int countBufferedBytes() {
        return this.bufReady.size() + this.bufCurrent.size();
    }

    public long getFirstReadyTxId() {
        assert (this.bufReady.firstTxId > 0L);
        return this.bufReady.firstTxId;
    }

    public int countReadyTxns() {
        return this.bufReady.numTxns;
    }

    public int countReadyBytes() {
        return this.bufReady.size();
    }

    private static class TxnBuffer
    extends DataOutputBuffer {
        long firstTxId;
        int numTxns;
        private final FSEditLogOp.Writer writer = new FSEditLogOp.Writer(this);

        public TxnBuffer(int initBufferSize) {
            super(initBufferSize);
            this.reset();
        }

        public void writeOp(FSEditLogOp op, int logVersion) throws IOException {
            if (this.firstTxId == -12345L) {
                this.firstTxId = op.txid;
            } else assert (op.txid > this.firstTxId);
            this.writer.writeOp(op, logVersion);
            ++this.numTxns;
        }

        @Override
        public DataOutputBuffer reset() {
            super.reset();
            this.firstTxId = -12345L;
            this.numTxns = 0;
            return this;
        }

        private void dumpRemainingEditLogs() {
            byte[] buf = this.getData();
            byte[] remainingRawEdits = Arrays.copyOfRange(buf, 0, this.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(remainingRawEdits);
            DataInputStream dis = new DataInputStream(bis);
            FSEditLogLoader.PositionTrackingInputStream tracker = new FSEditLogLoader.PositionTrackingInputStream(bis);
            FSEditLogOp.Reader reader = FSEditLogOp.Reader.create(dis, tracker, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            LOG.warn("The edits buffer is " + this.size() + " bytes long with " + this.numTxns + " unflushed transactions. Below is the list of unflushed transactions:");
            int numTransactions = 0;
            try {
                FSEditLogOp op;
                while ((op = reader.readOp(false)) != null) {
                    LOG.warn("Unflushed op [" + numTransactions + "]: " + op);
                    ++numTransactions;
                }
            }
            catch (IOException ioe) {
                LOG.warn("Unable to dump remaining ops. Remaining raw bytes: " + Hex.encodeHexString(remainingRawEdits), ioe);
            }
        }
    }
}

