/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.sps;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.balancer.KeyManager;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.sps.BlockDispatcher;
import org.apache.hadoop.hdfs.server.common.sps.BlockMovementAttemptFinished;
import org.apache.hadoop.hdfs.server.common.sps.BlockMovementStatus;
import org.apache.hadoop.hdfs.server.common.sps.BlockStorageMovementTracker;
import org.apache.hadoop.hdfs.server.common.sps.BlocksMovementsStatusHandler;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockMoveTaskHandler;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.protocol.BlockStorageMovementCommand;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Daemon;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExternalSPSBlockMoveTaskHandler
implements BlockMoveTaskHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSPSBlockMoveTaskHandler.class);
    private final ExecutorService moveExecutor;
    private final CompletionService<BlockMovementAttemptFinished> mCompletionServ;
    private final NameNodeConnector nnc;
    private final SaslDataTransferClient saslClient;
    private final BlockStorageMovementTracker blkMovementTracker;
    private Daemon movementTrackerThread;
    private final SPSService service;
    private final BlockDispatcher blkDispatcher;

    public ExternalSPSBlockMoveTaskHandler(Configuration conf, NameNodeConnector nnc, SPSService spsService) {
        int moverThreads = conf.getInt("dfs.mover.moverThreads", 1000);
        this.moveExecutor = this.initializeBlockMoverThreadPool(moverThreads);
        this.mCompletionServ = new ExecutorCompletionService<BlockMovementAttemptFinished>(this.moveExecutor);
        this.nnc = nnc;
        this.saslClient = new SaslDataTransferClient(conf, DataTransferSaslUtil.getSaslPropertiesResolver(conf), TrustedChannelResolver.getInstance(conf), nnc.getFallbackToSimpleAuth());
        this.blkMovementTracker = new BlockStorageMovementTracker(this.mCompletionServ, new ExternalBlocksMovementsStatusHandler());
        this.service = spsService;
        boolean connectToDnViaHostname = conf.getBoolean("dfs.client.use.datanode.hostname", false);
        int ioFileBufferSize = DFSUtilClient.getIoFileBufferSize(conf);
        this.blkDispatcher = new BlockDispatcher(60000, ioFileBufferSize, connectToDnViaHostname);
        this.startMovementTracker();
    }

    private void startMovementTracker() {
        this.movementTrackerThread = new Daemon(this.blkMovementTracker);
        this.movementTrackerThread.setName("BlockStorageMovementTracker");
        this.movementTrackerThread.start();
    }

    private ThreadPoolExecutor initializeBlockMoverThreadPool(int num) {
        LOG.debug("Block mover to satisfy storage policy; pool threads={}", (Object)num);
        ThreadPoolExecutor moverThreadPool = new ThreadPoolExecutor(1, num, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new Daemon.DaemonFactory(){
            private final AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = super.newThread(r);
                t.setName("BlockMoverTask-" + this.threadIndex.getAndIncrement());
                return t;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor e) {
                LOG.info("Execution for block movement to satisfy storage policy got rejected, Executing in current thread");
                super.rejectedExecution(runnable, e);
            }
        });
        moverThreadPool.allowCoreThreadTimeOut(true);
        return moverThreadPool;
    }

    @Override
    public void submitMoveTask(BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo) throws IOException {
        LOG.debug("Received BlockMovingTask {}", (Object)blkMovingInfo);
        BlockMovingTask blockMovingTask = new BlockMovingTask(blkMovingInfo);
        this.mCompletionServ.submit(blockMovingTask);
    }

    void cleanUp() {
        this.blkMovementTracker.stopTracking();
        if (this.movementTrackerThread != null) {
            this.movementTrackerThread.interrupt();
        }
    }

    private class BlockMovingTask
    implements Callable<BlockMovementAttemptFinished> {
        private final BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo;

        BlockMovingTask(BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo) {
            this.blkMovingInfo = blkMovingInfo;
        }

        @Override
        public BlockMovementAttemptFinished call() {
            BlockMovementStatus blkMovementStatus = this.moveBlock();
            return new BlockMovementAttemptFinished(this.blkMovingInfo.getBlock(), this.blkMovingInfo.getSource(), this.blkMovingInfo.getTarget(), this.blkMovingInfo.getTargetStorageType(), blkMovementStatus);
        }

        private BlockMovementStatus moveBlock() {
            Token<BlockTokenIdentifier> accessToken;
            ExtendedBlock eb = new ExtendedBlock(ExternalSPSBlockMoveTaskHandler.this.nnc.getBlockpoolID(), this.blkMovingInfo.getBlock());
            KeyManager km3 = ExternalSPSBlockMoveTaskHandler.this.nnc.getKeyManager();
            try {
                accessToken = km3.getAccessToken(eb, new StorageType[]{this.blkMovingInfo.getTargetStorageType()}, new String[0]);
            }
            catch (IOException e) {
                LOG.warn("Failed to move block:{} from src:{} to destin:{} to satisfy storageType:{}", new Object[]{this.blkMovingInfo.getBlock(), this.blkMovingInfo.getSource(), this.blkMovingInfo.getTarget(), this.blkMovingInfo.getTargetStorageType(), e});
                return BlockMovementStatus.DN_BLK_STORAGE_MOVEMENT_FAILURE;
            }
            return ExternalSPSBlockMoveTaskHandler.this.blkDispatcher.moveBlock(this.blkMovingInfo, ExternalSPSBlockMoveTaskHandler.this.saslClient, eb, new Socket(), km3, accessToken);
        }
    }

    private class ExternalBlocksMovementsStatusHandler
    implements BlocksMovementsStatusHandler {
        private ExternalBlocksMovementsStatusHandler() {
        }

        @Override
        public void handle(BlockMovementAttemptFinished attemptedMove) {
            ExternalSPSBlockMoveTaskHandler.this.service.notifyStorageMovementAttemptFinishedBlk(attemptedMove.getTargetDatanode(), attemptedMove.getTargetType(), attemptedMove.getBlock());
        }
    }
}

