/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.trino.hadoop.$internal.org.apache.avro.AvroRuntimeException;
import io.trino.hadoop.$internal.org.apache.avro.Schema;
import io.trino.hadoop.$internal.org.apache.avro.io.DatumReader;
import io.trino.hadoop.$internal.org.apache.avro.io.Decoder;
import io.trino.hadoop.$internal.org.apache.avro.io.DecoderFactory;
import io.trino.hadoop.$internal.org.apache.avro.specific.SpecificData;
import io.trino.hadoop.$internal.org.apache.avro.specific.SpecificDatumReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EventReader
implements Closeable {
    private String version;
    private Schema schema;
    private DataInputStream in;
    private Decoder decoder;
    private DatumReader reader;

    public EventReader(FileSystem fs, Path name) throws IOException {
        this(fs.open(name));
    }

    public EventReader(DataInputStream in) throws IOException {
        this.in = in;
        this.version = in.readLine();
        Schema myschema = new SpecificData(Event.class.getClassLoader()).getSchema((Type)((Object)Event.class));
        Schema.Parser parser = new Schema.Parser();
        String eventschema = in.readLine();
        if (null != eventschema) {
            try {
                this.schema = parser.parse(eventschema);
                this.reader = new SpecificDatumReader(this.schema, myschema);
                if ("Avro-Json".equals(this.version)) {
                    this.decoder = DecoderFactory.get().jsonDecoder(this.schema, in);
                }
                if ("Avro-Binary".equals(this.version)) {
                    this.decoder = DecoderFactory.get().binaryDecoder(in, null);
                }
                throw new IOException("Incompatible event log version: " + this.version);
            }
            catch (AvroRuntimeException e) {
                throw new IOException(e);
            }
        } else {
            throw new IOException("Event schema string not parsed since its null");
        }
    }

    public HistoryEvent getNextEvent() throws IOException {
        HistoryEvent result;
        Event wrapper;
        try {
            wrapper = this.reader.read(null, this.decoder);
        }
        catch (EOFException e) {
            return null;
        }
        switch (wrapper.getType()) {
            case JOB_SUBMITTED: {
                result = new JobSubmittedEvent();
                break;
            }
            case JOB_INITED: {
                result = new JobInitedEvent();
                break;
            }
            case JOB_FINISHED: {
                result = new JobFinishedEvent();
                break;
            }
            case JOB_PRIORITY_CHANGED: {
                result = new JobPriorityChangeEvent();
                break;
            }
            case JOB_QUEUE_CHANGED: {
                result = new JobQueueChangeEvent();
                break;
            }
            case JOB_STATUS_CHANGED: {
                result = new JobStatusChangedEvent();
                break;
            }
            case JOB_FAILED: {
                result = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_KILLED: {
                result = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_ERROR: {
                result = new JobUnsuccessfulCompletionEvent();
                break;
            }
            case JOB_INFO_CHANGED: {
                result = new JobInfoChangeEvent();
                break;
            }
            case TASK_STARTED: {
                result = new TaskStartedEvent();
                break;
            }
            case TASK_FINISHED: {
                result = new TaskFinishedEvent();
                break;
            }
            case TASK_FAILED: {
                result = new TaskFailedEvent();
                break;
            }
            case TASK_UPDATED: {
                result = new TaskUpdatedEvent();
                break;
            }
            case MAP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case MAP_ATTEMPT_FINISHED: {
                result = new MapAttemptFinishedEvent();
                break;
            }
            case MAP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case MAP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FINISHED: {
                result = new ReduceAttemptFinishedEvent();
                break;
            }
            case REDUCE_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case REDUCE_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case SETUP_ATTEMPT_FINISHED: {
                result = new TaskAttemptFinishedEvent();
                break;
            }
            case SETUP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case SETUP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_STARTED: {
                result = new TaskAttemptStartedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FINISHED: {
                result = new TaskAttemptFinishedEvent();
                break;
            }
            case CLEANUP_ATTEMPT_FAILED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case CLEANUP_ATTEMPT_KILLED: {
                result = new TaskAttemptUnsuccessfulCompletionEvent();
                break;
            }
            case AM_STARTED: {
                result = new AMStartedEvent();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event type: " + (Object)((Object)wrapper.getType()));
            }
        }
        result.setDatum(wrapper.getEvent());
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    static Counters fromAvro(JhCounters counters) {
        Counters result = new Counters();
        if (counters != null) {
            for (JhCounterGroup g2 : counters.getGroups()) {
                CounterGroup group = (CounterGroup)result.addGroup(StringInterner.weakIntern(g2.getName().toString()), StringInterner.weakIntern(g2.getDisplayName().toString()));
                for (JhCounter c : g2.getCounts()) {
                    group.addCounter(StringInterner.weakIntern(c.getName().toString()), StringInterner.weakIntern(c.getDisplayName().toString()), c.getValue());
                }
            }
        }
        return result;
    }
}

