/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import io.trino.filesystem.tracing.TracingInputFile;
import io.trino.filesystem.tracing.TracingOutputFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class TracingFileSystem
implements TrinoFileSystem {
    private final Tracer tracer;
    private final TrinoFileSystem delegate;

    public TracingFileSystem(Tracer tracer, TrinoFileSystem delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public TrinoInputFile newInputFile(Location location) {
        return new TracingInputFile(this.tracer, this.delegate.newInputFile(location), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(Location location, long length) {
        return new TracingInputFile(this.tracer, this.delegate.newInputFile(location, length), Optional.of(length));
    }

    @Override
    public TrinoOutputFile newOutputFile(Location location) {
        return new TracingOutputFile(this.tracer, this.delegate.newOutputFile(location));
    }

    @Override
    public void deleteFile(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteFile").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteFile(location));
    }

    @Override
    public void deleteFiles(Collection<Location> locations) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteFiles").setAttribute(FileSystemAttributes.FILE_LOCATION_COUNT, (Object)locations.size()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteFiles(locations));
    }

    @Override
    public void deleteDirectory(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteDirectory").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteDirectory(location));
    }

    @Override
    public void renameFile(Location source, Location target) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.renameFile").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)source.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameFile(source, target));
    }

    @Override
    public FileIterator listFiles(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.listFiles").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.listFiles(location));
    }

    @Override
    public Optional<Boolean> directoryExists(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.directoryExists").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.directoryExists(location));
    }

    @Override
    public void createDirectory(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.createDirectory").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createDirectory(location));
    }

    @Override
    public void renameDirectory(Location source, Location target) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.renameDirectory").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)source.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameDirectory(source, target));
    }

    @Override
    public Set<Location> listDirectories(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.listDirectories").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location.toString()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.listDirectories(location));
    }
}

