/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.metastore.Database;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class HiveSchemaProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final List<PropertyMetadata<?>> SCHEMA_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"location", (String)"Base file system location URI", null, (boolean)false));

    private HiveSchemaProperties() {
    }

    public static Map<String, Object> fromDatabase(Database db) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        db.getLocation().ifPresent(location -> result.put((Object)LOCATION_PROPERTY, location));
        return result.buildOrThrow();
    }

    public static Optional<String> getLocation(Map<String, Object> schemaProperties) {
        return Optional.ofNullable((String)schemaProperties.get(LOCATION_PROPERTY));
    }
}

