/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class RecordingMetastoreConfig {
    private String recordingPath;
    private boolean replay;
    private Duration recordingDuration = new Duration(10.0, TimeUnit.MINUTES);

    @Config(value="hive.metastore-recording-path")
    public RecordingMetastoreConfig setRecordingPath(String recordingPath) {
        this.recordingPath = recordingPath;
        return this;
    }

    public String getRecordingPath() {
        return this.recordingPath;
    }

    @Config(value="hive.replay-metastore-recording")
    public RecordingMetastoreConfig setReplay(boolean replay) {
        this.replay = replay;
        return this;
    }

    public boolean isReplay() {
        return this.replay;
    }

    @Config(value="hive.metastore-recording-duration")
    public RecordingMetastoreConfig setRecordingDuration(Duration recordingDuration) {
        this.recordingDuration = recordingDuration;
        return this;
    }

    @NotNull
    public Duration getRecordingDuration() {
        return this.recordingDuration;
    }
}

