/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class ImpersonationCachingConfig {
    private Duration userMetastoreCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private long userMetastoreCacheMaximumSize = 1000L;

    @NotNull
    public Duration getUserMetastoreCacheTtl() {
        return this.userMetastoreCacheTtl;
    }

    @Config(value="hive.user-metastore-cache-ttl")
    public ImpersonationCachingConfig setUserMetastoreCacheTtl(Duration userMetastoreCacheTtl) {
        this.userMetastoreCacheTtl = userMetastoreCacheTtl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) long getUserMetastoreCacheMaximumSize() {
        return this.userMetastoreCacheMaximumSize;
    }

    @Config(value="hive.user-metastore-cache-maximum-size")
    public ImpersonationCachingConfig setUserMetastoreCacheMaximumSize(long userMetastoreCacheMaximumSize) {
        this.userMetastoreCacheMaximumSize = userMetastoreCacheMaximumSize;
        return this;
    }
}

