/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;

public class DisabledGlueColumnStatisticsProvider
implements GlueColumnStatisticsProvider {
    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ImmutableSet.of();
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(Table table) {
        return ImmutableMap.of();
    }

    @Override
    public Map<Partition, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(Collection<Partition> partitions) {
        return (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), partition -> ImmutableMap.of()));
    }

    @Override
    public void updateTableColumnStatistics(Table table, Map<String, HiveColumnStatistics> columnStatistics) {
        if (!columnStatistics.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore column level statistics are disabled");
        }
    }

    @Override
    public void updatePartitionStatistics(Set<GlueColumnStatisticsProvider.PartitionStatisticsUpdate> partitionStatisticsUpdates) {
        if (partitionStatisticsUpdates.stream().anyMatch(update -> !update.getColumnStatistics().isEmpty())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue metastore column level statistics are disabled");
        }
    }
}

