/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.google.common.base.Preconditions;
import io.trino.hdfs.s3.AwsCurrentRegionHolder;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.util.Set;

public final class GlueClientUtil {
    private GlueClientUtil() {
    }

    public static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config, AWSCredentialsProvider credentialsProvider, Set<RequestHandler2> requestHandlers, RequestMetricCollector metricsCollector) {
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections()).withMaxErrorRetry(config.getMaxGlueErrorRetries());
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)((AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withMetricsCollector(metricsCollector)).withClientConfiguration(clientConfig);
        asyncGlueClientBuilder.setRequestHandlers((RequestHandler2[])requestHandlers.toArray(RequestHandler2[]::new));
        if (config.getGlueEndpointUrl().isPresent()) {
            Preconditions.checkArgument((boolean)config.getGlueRegion().isPresent(), (Object)"Glue region must be set when Glue endpoint URL is set");
            asyncGlueClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getGlueEndpointUrl().get(), config.getGlueRegion().get()));
        } else if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion()) {
            asyncGlueClientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEC2Metadata().getName());
        }
        asyncGlueClientBuilder.setCredentials(credentialsProvider);
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }
}

