/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.coercions.DoubleToVarcharCoercer;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public final class OrcTypeTranslator {
    private OrcTypeTranslator() {
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(OrcType.OrcTypeKind fromOrcType, Type toTrinoType) {
        if (fromOrcType == OrcType.OrcTypeKind.TIMESTAMP && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            return Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(TimestampType.TIMESTAMP_NANOS, varcharType));
        }
        if (OrcTypeTranslator.isVarcharType(fromOrcType) && toTrinoType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)toTrinoType;
            if (timestampType.isShort()) {
                return Optional.of(new TimestampCoercer.VarcharToShortTimestampCoercer(VarcharType.createUnboundedVarcharType(), timestampType));
            }
            return Optional.of(new TimestampCoercer.VarcharToLongTimestampCoercer(VarcharType.createUnboundedVarcharType(), timestampType));
        }
        if (fromOrcType == OrcType.OrcTypeKind.DOUBLE && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            return Optional.of(new DoubleToVarcharCoercer(varcharType, true));
        }
        return Optional.empty();
    }

    private static boolean isVarcharType(OrcType.OrcTypeKind orcTypeKind) {
        return orcTypeKind == OrcType.OrcTypeKind.STRING || orcTypeKind == OrcType.OrcTypeKind.VARCHAR;
    }
}

