/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class DeltaLakeBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final List<MethodHandle> hashCodeInvokers;

    public DeltaLakeBucketFunction(TypeOperators typeOperators, List<DeltaLakeColumnHandle> partitioningColumns, int bucketCount) {
        this.hashCodeInvokers = (List)partitioningColumns.stream().peek(column -> Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column)).map(DeltaLakeColumnHandle::getBaseType).map(type -> typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}))).collect(ImmutableList.toImmutableList());
        this.bucketCount = bucketCount;
    }

    public int getBucket(Page page, int position) {
        long hash = 0L;
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block = page.getBlock(channel);
            long valueHash = DeltaLakeBucketFunction.hashValue(this.hashCodeInvokers.get(channel), block, position);
            hash = 31L * hash + valueHash;
        }
        return (int)((hash & Long.MAX_VALUE) % (long)this.bucketCount);
    }

    private static long hashValue(MethodHandle method, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        try {
            return method.invokeExact(block, position);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }
}

