/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorAccessControl;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeEventListener;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeConnector;
import io.trino.plugin.deltalake.DeltaLakeModule;
import io.trino.plugin.deltalake.DeltaLakeSchemaProperties;
import io.trino.plugin.deltalake.DeltaLakeSecurityModule;
import io.trino.plugin.deltalake.DeltaLakeSynchronizerModule;
import io.trino.plugin.deltalake.DeltaLakeTableProperties;
import io.trino.plugin.deltalake.DeltaLakeTransactionManager;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastoreModule;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalDeltaLakeConnectorFactory {
    private InternalDeltaLakeConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Optional<Module> metastoreModule, Optional<TrinoFileSystemFactory> fileSystemFactory, Module module) {
        ClassLoader classLoader = InternalDeltaLakeConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule("io.trino.plugin.deltalake", "trino.plugin.deltalake"), new JsonModule(), new MBeanServerModule(), new CatalogNameModule(catalogName), metastoreModule.orElse((Module)new DeltaLakeMetastoreModule()), new DeltaLakeModule(), new DeltaLakeSecurityModule(), new DeltaLakeSynchronizerModule(), fileSystemFactory.map(factory -> binder -> binder.bind(TrinoFileSystemFactory.class).toInstance(factory)).orElseGet(() -> new FileSystemModule(catalogName, context.getNodeManager(), context.getOpenTelemetry())), binder -> {
                binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
                binder.bind(Tracer.class).toInstance((Object)context.getTracer());
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
                Multibinder.newSetBinder((Binder)binder, EventListener.class);
            }, module});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider connectorPageSink = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            Set sessionPropertiesProviders = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SessionPropertiesProvider>>(){}));
            DeltaLakeTableProperties deltaLakeTableProperties = (DeltaLakeTableProperties)injector.getInstance(DeltaLakeTableProperties.class);
            DeltaLakeAnalyzeProperties deltaLakeAnalyzeProperties = (DeltaLakeAnalyzeProperties)injector.getInstance(DeltaLakeAnalyzeProperties.class);
            DeltaLakeTransactionManager transactionManager = (DeltaLakeTransactionManager)injector.getInstance(DeltaLakeTransactionManager.class);
            Optional<ConnectorAccessControl> deltaAccessControl = ((Optional)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<ConnectorAccessControl>>(){}))).map(accessControl -> new ClassLoaderSafeConnectorAccessControl(accessControl, classLoader));
            Set eventListeners = (Set)((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<EventListener>>(){}))).stream().map(listener -> new ClassLoaderSafeEventListener(listener, classLoader)).collect(ImmutableSet.toImmutableSet());
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            Set tableProcedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<TableProcedureMetadata>>(){}));
            Set connectorTableFunctions = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ConnectorTableFunction>>(){}));
            FunctionProvider functionProvider = (FunctionProvider)injector.getInstance(FunctionProvider.class);
            Preconditions.checkState((!injector.getBindings().containsKey(Key.get(HiveConfig.class)) ? 1 : 0) != 0, (Object)"HiveConfig should not be bound");
            DeltaLakeConnector deltaLakeConnector = new DeltaLakeConnector(injector, lifeCycleManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(connectorPageSink, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), (Set<SystemTable>)ImmutableSet.of(), procedures, tableProcedures, sessionPropertiesProviders, DeltaLakeSchemaProperties.SCHEMA_PROPERTIES, deltaLakeTableProperties.getTableProperties(), deltaLakeAnalyzeProperties.getAnalyzeProperties(), deltaAccessControl, eventListeners, transactionManager, connectorTableFunctions, functionProvider);
            return deltaLakeConnector;
        }
    }
}

