/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.functions.tablechanges;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakePageSource;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesFileType;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesSplit;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesTableFunctionHandle;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class TableChangesFunctionProcessor
implements TableFunctionSplitProcessor {
    private static final int NUMBER_OF_ADDITIONAL_COLUMNS_FOR_CDF_FILE = 2;
    private static final int NUMBER_OF_ADDITIONAL_COLUMNS_FOR_DATA_FILE = 3;
    private static final Page EMPTY_PAGE = new Page(0);
    private final TableChangesFileType fileType;
    private final DeltaLakePageSource deltaLakePageSource;
    private final Block currentVersionAsBlock;
    private final Block currentVersionCommitTimestampAsBlock;

    public TableChangesFunctionProcessor(ConnectorSession session, TrinoFileSystemFactory fileSystemFactory, DateTimeZone parquetDateTimeZone, int domainCompactionThreshold, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderOptions parquetReaderOptions, TableChangesTableFunctionHandle handle, TableChangesSplit tableChangesSplit) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        Objects.requireNonNull(parquetDateTimeZone, "parquetDateTimeZone is null");
        Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(tableChangesSplit, "tableChangesSplit is null");
        this.fileType = tableChangesSplit.fileType();
        this.deltaLakePageSource = TableChangesFunctionProcessor.createDeltaLakePageSource(session, fileSystemFactory, parquetDateTimeZone, domainCompactionThreshold, fileFormatDataSourceStats, parquetReaderOptions, handle, tableChangesSplit);
        this.currentVersionAsBlock = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)tableChangesSplit.currentVersion());
        this.currentVersionCommitTimestampAsBlock = Utils.nativeValueToBlock((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, (Object)DateTimeEncoding.packDateTimeWithZone((long)tableChangesSplit.currentVersionCommitTimestamp(), (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    public TableFunctionProcessorState process() {
        if (this.fileType == TableChangesFileType.CDF_FILE) {
            return this.processCdfFile();
        }
        return this.processDataFile();
    }

    private TableFunctionProcessorState processCdfFile() {
        Page page = this.deltaLakePageSource.getNextPage();
        if (page != null) {
            int filePageColumns = page.getChannelCount();
            Block[] resultBlock = new Block[filePageColumns + 2];
            for (int i = 0; i < filePageColumns; ++i) {
                resultBlock[i] = page.getBlock(i);
            }
            resultBlock[filePageColumns] = RunLengthEncodedBlock.create((Block)this.currentVersionAsBlock, (int)page.getPositionCount());
            resultBlock[filePageColumns + 1] = RunLengthEncodedBlock.create((Block)this.currentVersionCommitTimestampAsBlock, (int)page.getPositionCount());
            return TableFunctionProcessorState.Processed.produced((Page)new Page(page.getPositionCount(), resultBlock));
        }
        if (this.deltaLakePageSource.isFinished()) {
            return TableFunctionProcessorState.Finished.FINISHED;
        }
        return TableFunctionProcessorState.Processed.produced((Page)EMPTY_PAGE);
    }

    private TableFunctionProcessorState processDataFile() {
        Page page = this.deltaLakePageSource.getNextPage();
        if (page != null) {
            int filePageColumns = page.getChannelCount();
            Block[] blocks = new Block[filePageColumns + 3];
            for (int i = 0; i < filePageColumns; ++i) {
                blocks[i] = page.getBlock(i);
            }
            blocks[filePageColumns] = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"insert")), (int)page.getPositionCount());
            blocks[filePageColumns + 1] = RunLengthEncodedBlock.create((Block)this.currentVersionAsBlock, (int)page.getPositionCount());
            blocks[filePageColumns + 2] = RunLengthEncodedBlock.create((Block)this.currentVersionCommitTimestampAsBlock, (int)page.getPositionCount());
            return TableFunctionProcessorState.Processed.produced((Page)new Page(page.getPositionCount(), blocks));
        }
        if (this.deltaLakePageSource.isFinished()) {
            return TableFunctionProcessorState.Finished.FINISHED;
        }
        return TableFunctionProcessorState.Processed.produced((Page)EMPTY_PAGE);
    }

    private static DeltaLakePageSource createDeltaLakePageSource(ConnectorSession session, TrinoFileSystemFactory fileSystemFactory, DateTimeZone parquetDateTimeZone, int domainCompactionThreshold, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderOptions parquetReaderOptions, TableChangesTableFunctionHandle handle, TableChangesSplit split) {
        TrinoFileSystem fileSystem = fileSystemFactory.create(session);
        TrinoInputFile inputFile = fileSystem.newInputFile(Location.of((String)split.path()), split.fileSize());
        Map<String, Optional<String>> partitionKeys = split.partitionKeys();
        parquetReaderOptions = parquetReaderOptions.withMaxReadBlockSize(DeltaLakeSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(DeltaLakeSessionProperties.getParquetMaxReadBlockRowCount(session)).withUseColumnIndex(DeltaLakeSessionProperties.isParquetUseColumnIndex(session));
        ImmutableList splitColumns = switch (split.fileType()) {
            default -> throw new IncompatibleClassChangeError();
            case TableChangesFileType.CDF_FILE -> ImmutableList.builder().addAll(handle.columns()).add((Object)new DeltaLakeColumnHandle("_change_type", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "_change_type", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty())).build();
            case TableChangesFileType.DATA_FILE -> handle.columns();
        };
        ReaderPageSource pageSource = ParquetPageSourceFactory.createPageSource((TrinoInputFile)inputFile, (long)0L, (long)split.fileSize(), (List)((List)splitColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR).map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList())), (List)ImmutableList.of((Object)TupleDomain.all()), (boolean)true, (DateTimeZone)parquetDateTimeZone, (FileFormatDataSourceStats)fileFormatDataSourceStats, (ParquetReaderOptions)parquetReaderOptions, Optional.empty(), (int)domainCompactionThreshold, (OptionalLong)OptionalLong.empty());
        Verify.verify((boolean)pageSource.getReaderColumns().isEmpty(), (String)"Unexpected reader columns: %s", pageSource.getReaderColumns().orElse(null));
        return new DeltaLakePageSource((List<DeltaLakeColumnHandle>)splitColumns, (Set<String>)ImmutableSet.of(), partitionKeys, Optional.empty(), pageSource.get(), Optional.empty(), split.path(), split.fileSize(), 0L, Optional::empty);
    }
}

