/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.DoNotCall;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.cardinality.HyperLogLog;
import java.util.Base64;
import java.util.Objects;
import java.util.OptionalLong;

public class DeltaLakeColumnStatistics {
    private final OptionalLong totalSizeInBytes;
    private final HyperLogLog ndvSummary;

    @JsonCreator
    @DoNotCall
    public static DeltaLakeColumnStatistics fromJson(@JsonProperty(value="totalSizeInBytes") OptionalLong totalSizeInBytes, @JsonProperty(value="ndvSummary") String ndvSummaryBase64) {
        Objects.requireNonNull(totalSizeInBytes, "totalSizeInBytes is null");
        Objects.requireNonNull(ndvSummaryBase64, "ndvSummaryBase64 is null");
        byte[] ndvSummaryBytes = Base64.getDecoder().decode(ndvSummaryBase64);
        return new DeltaLakeColumnStatistics(totalSizeInBytes, HyperLogLog.newInstance((Slice)Slices.wrappedBuffer((byte[])ndvSummaryBytes)));
    }

    public static DeltaLakeColumnStatistics create(OptionalLong totalSizeInBytes, HyperLogLog ndvSummary) {
        return new DeltaLakeColumnStatistics(totalSizeInBytes, ndvSummary);
    }

    private DeltaLakeColumnStatistics(OptionalLong totalSizeInBytes, HyperLogLog ndvSummary) {
        this.totalSizeInBytes = Objects.requireNonNull(totalSizeInBytes, "totalSizeInBytes is null");
        this.ndvSummary = Objects.requireNonNull(ndvSummary, "ndvSummary is null");
    }

    @JsonProperty
    public OptionalLong getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @JsonProperty(value="ndvSummary")
    public String getNdvSummaryBase64() {
        return Base64.getEncoder().encodeToString(this.ndvSummary.serialize().getBytes());
    }

    public HyperLogLog getNdvSummary() {
        return this.ndvSummary;
    }

    public DeltaLakeColumnStatistics update(DeltaLakeColumnStatistics newStatistics) {
        OptionalLong totalSizeInBytes = DeltaLakeColumnStatistics.mergeIntegerStatistics(this.totalSizeInBytes, newStatistics.totalSizeInBytes);
        HyperLogLog ndvSummary = HyperLogLog.newInstance((Slice)this.ndvSummary.serialize());
        ndvSummary.mergeWith(newStatistics.ndvSummary);
        return new DeltaLakeColumnStatistics(totalSizeInBytes, ndvSummary);
    }

    private static OptionalLong mergeIntegerStatistics(OptionalLong first, OptionalLong second) {
        if (first.isPresent() && second.isPresent()) {
            return OptionalLong.of(first.getAsLong() + second.getAsLong());
        }
        return OptionalLong.empty();
    }
}

