/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommitInfoEntry {
    private final long version;
    private final long timestamp;
    private final String userId;
    private final String userName;
    private final String operation;
    private final Map<String, String> operationParameters;
    private final Job job;
    private final Notebook notebook;
    private final String clusterId;
    private final long readVersion;
    private final String isolationLevel;
    private final Optional<Boolean> isBlindAppend;

    @JsonCreator
    public CommitInfoEntry(@JsonProperty(value="version") long version, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="userId") String userId, @JsonProperty(value="userName") String userName, @JsonProperty(value="operation") String operation, @JsonProperty(value="operationParameters") Map<String, String> operationParameters, @JsonProperty(value="job") Job job, @JsonProperty(value="notebook") Notebook notebook, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="readVersion") long readVersion, @JsonProperty(value="isolationLevel") String isolationLevel, @JsonProperty(value="isBlindAppend") Optional<Boolean> isBlindAppend) {
        this.version = version;
        this.timestamp = timestamp;
        this.userId = userId;
        this.userName = userName;
        this.operation = operation;
        this.operationParameters = operationParameters;
        this.job = job;
        this.notebook = notebook;
        this.clusterId = clusterId;
        this.readVersion = readVersion;
        this.isolationLevel = isolationLevel;
        this.isBlindAppend = isBlindAppend;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty
    public Map<String, String> getOperationParameters() {
        return this.operationParameters;
    }

    @JsonProperty
    public Job getJob() {
        return this.job;
    }

    @JsonProperty
    public Notebook getNotebook() {
        return this.notebook;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public long getReadVersion() {
        return this.readVersion;
    }

    @JsonProperty
    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @JsonProperty(value="isBlindAppend")
    public Optional<Boolean> isBlindAppend() {
        return this.isBlindAppend;
    }

    public CommitInfoEntry withVersion(long version) {
        return new CommitInfoEntry(version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.job, this.notebook, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend);
    }

    public String toString() {
        return String.format("CommitInfoEntry{version=%d, timestamp=%d, userId=%s, userName=%s, operation=%s, operationParameters=%s, job=%s, notebook=%s, clusterId=%s, readVersion=%d, isolationLevel=%s, isBlindAppend=%b}", this.version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.job, this.notebook, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitInfoEntry other = (CommitInfoEntry)o;
        return this.version == other.version && this.timestamp == other.timestamp && Objects.equals(this.userId, other.userId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.operation, other.operation) && Objects.equals(this.operationParameters, other.operationParameters) && Objects.equals(this.job, other.job) && Objects.equals(this.notebook, other.notebook) && Objects.equals(this.clusterId, other.clusterId) && this.readVersion == other.readVersion && Objects.equals(this.isolationLevel, other.isolationLevel) && Objects.equals(this.isBlindAppend, other.isBlindAppend);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.job, this.notebook, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend);
    }

    public static class Job {
        private final String jobId;
        private final String jobName;
        private final String runId;
        private final String jobOwnerId;
        private final String triggerType;

        @JsonCreator
        public Job(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="jobName") String jobName, @JsonProperty(value="runId") String runId, @JsonProperty(value="jobOwnerId") String jobOwnerId, @JsonProperty(value="triggerType") String triggerType) {
            this.jobId = jobId;
            this.jobName = jobName;
            this.runId = runId;
            this.jobOwnerId = jobOwnerId;
            this.triggerType = triggerType;
        }

        @JsonProperty
        public String getJobId() {
            return this.jobId;
        }

        @JsonProperty
        public String getJobName() {
            return this.jobName;
        }

        @JsonProperty
        public String getRunId() {
            return this.runId;
        }

        @JsonProperty
        public String getJobOwnerId() {
            return this.jobOwnerId;
        }

        @JsonProperty
        public String getTriggerType() {
            return this.triggerType;
        }

        public String toString() {
            return String.format("CommitInfoEntry.Job{jobId=%s, jobName=%s, runId=%s, jobOwnerId=%s, triggerType=%s}", this.jobId, this.jobName, this.runId, this.jobOwnerId, this.triggerType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Job other = (Job)o;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.jobName, other.jobName) && Objects.equals(this.runId, other.runId) && Objects.equals(this.jobOwnerId, other.jobOwnerId) && Objects.equals(this.triggerType, other.triggerType);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.jobName, this.runId, this.jobOwnerId, this.triggerType);
        }
    }

    public static class Notebook {
        private final String notebookId;

        @JsonCreator
        public Notebook(@JsonProperty(value="notebookId") String notebookId) {
            this.notebookId = notebookId;
        }

        @JsonProperty
        public String getNotebookId() {
            return this.notebookId;
        }

        public String toString() {
            return String.format("CommitInfoEntry.Notebook{notebookId=%s}", this.notebookId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Notebook other = (Notebook)o;
            return Objects.equals(this.notebookId, other.notebookId);
        }

        public int hashCode() {
            return Objects.hash(this.notebookId);
        }
    }
}

