/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.slice.SizeOf;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CanonicalColumnName;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeDataFileCacheEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TransactionLogAccess {
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ParquetReaderOptions parquetReaderOptions;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final int domainCompactionThreshold;
    private final Cache<TableLocation, TableSnapshot> tableSnapshots;
    private final Cache<TableVersion, DeltaLakeDataFileCacheEntry> activeDataFileCache;

    @Inject
    public TransactionLogAccess(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, DeltaLakeConfig deltaLakeConfig, FileFormatDataSourceStats fileFormatDataSourceStats, TrinoFileSystemFactory fileSystemFactory, ParquetReaderConfig parquetReaderConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions().withBloomFilter(false);
        this.checkpointRowStatisticsWritingEnabled = deltaLakeConfig.isCheckpointRowStatisticsWritingEnabled();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.tableSnapshots = EvictableCacheBuilder.newBuilder().expireAfterWrite(deltaLakeConfig.getMetadataCacheTtl().toMillis(), TimeUnit.MILLISECONDS).maximumSize(deltaLakeConfig.getMetadataCacheMaxSize()).shareNothingWhenDisabled().recordStats().build();
        this.activeDataFileCache = EvictableCacheBuilder.newBuilder().weigher((key, value) -> Ints.saturatedCast((long)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes()))).maximumWeight(deltaLakeConfig.getDataFileCacheSize().toBytes()).expireAfterWrite(deltaLakeConfig.getDataFileCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDataFileMetadataCacheStats() {
        return new CacheStatsMBean(this.activeDataFileCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getMetadataCacheStats() {
        return new CacheStatsMBean(this.tableSnapshots);
    }

    public TableSnapshot loadSnapshot(ConnectorSession session, SchemaTableName table, String tableLocation) throws IOException {
        TableSnapshot snapshot;
        TableLocation cacheKey = new TableLocation(table, tableLocation);
        TableSnapshot cachedSnapshot = (TableSnapshot)this.tableSnapshots.getIfPresent((Object)cacheKey);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        if (cachedSnapshot == null) {
            try {
                Optional<LastCheckpoint> lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, tableLocation);
                snapshot = (TableSnapshot)this.tableSnapshots.get((Object)cacheKey, () -> TableSnapshot.load(table, lastCheckpoint, fileSystem, tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e);
            }
        } else {
            Optional<TableSnapshot> updatedSnapshot = cachedSnapshot.getUpdatedSnapshot(fileSystem, Optional.empty());
            if (updatedSnapshot.isPresent()) {
                snapshot = updatedSnapshot.get();
                this.tableSnapshots.asMap().replace(cacheKey, cachedSnapshot, snapshot);
            } else {
                snapshot = cachedSnapshot;
            }
        }
        return snapshot;
    }

    public void flushCache() {
        this.tableSnapshots.invalidateAll();
        this.activeDataFileCache.invalidateAll();
    }

    public void invalidateCache(SchemaTableName schemaTableName, Optional<String> tableLocation) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        tableLocation.ifPresent(location -> {
            CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.location().equals(location));
            CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.tableLocation().location().equals(location));
        });
        CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.tableName().equals((Object)schemaTableName));
        CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.tableLocation().tableName().equals((Object)schemaTableName));
    }

    public MetadataEntry getMetadataEntry(TableSnapshot tableSnapshot, ConnectorSession session) {
        if (tableSnapshot.getCachedMetadata().isEmpty()) {
            try (Stream metadataEntries = this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.METADATA, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getMetaData).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);){
                tableSnapshot.setCachedMetadata(metadataEntries.reduce((first, second) -> second));
            }
        }
        return tableSnapshot.getCachedMetadata().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + tableSnapshot.getTable()));
    }

    @Deprecated
    public List<AddFileEntry> getActiveFiles(TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, ConnectorSession session) {
        return this.retrieveActiveFiles(tableSnapshot, metadataEntry, protocolEntry, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), session);
    }

    public List<AddFileEntry> getActiveFiles(TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Set<DeltaLakeColumnHandle>> projectedColumns, ConnectorSession session) {
        Optional<Object> addStatsMinMaxColumnFilter = Optional.of(Predicates.alwaysFalse());
        if (projectedColumns.isPresent()) {
            Set baseColumnNames = (Set)projectedColumns.get().stream().filter(DeltaLakeColumnHandle::isBaseColumn).map(DeltaLakeColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
            addStatsMinMaxColumnFilter = Optional.of(baseColumnNames::contains);
        }
        return this.retrieveActiveFiles(tableSnapshot, metadataEntry, protocolEntry, partitionConstraint, addStatsMinMaxColumnFilter, session);
    }

    private List<AddFileEntry> retrieveActiveFiles(TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter, ConnectorSession session) {
        try {
            if (DeltaLakeSessionProperties.isCheckpointFilteringEnabled(session)) {
                return (List)this.loadActiveFiles(tableSnapshot, metadataEntry, protocolEntry, partitionConstraint, addStatsMinMaxColumnFilter, session).stream().collect(ImmutableList.toImmutableList());
            }
            TableVersion tableVersion = new TableVersion(new TableLocation(tableSnapshot.getTable(), tableSnapshot.getTableLocation()), tableSnapshot.getVersion());
            DeltaLakeDataFileCacheEntry cacheEntry = (DeltaLakeDataFileCacheEntry)this.activeDataFileCache.get((Object)tableVersion, () -> {
                DeltaLakeDataFileCacheEntry oldCached = this.activeDataFileCache.asMap().keySet().stream().filter(key -> key.tableLocation().equals(tableVersion.tableLocation()) && key.version() < tableVersion.version()).flatMap(key -> Optional.ofNullable((DeltaLakeDataFileCacheEntry)this.activeDataFileCache.getIfPresent(key)).map(value -> Map.entry(key, value)).stream()).max(Comparator.comparing(entry -> ((TableVersion)entry.getKey()).version())).map(Map.Entry::getValue).orElse(null);
                if (oldCached != null) {
                    try {
                        List<DeltaLakeTransactionLogEntry> newEntries = TransactionLogAccess.getJsonEntries(oldCached.getVersion(), tableSnapshot.getVersion(), tableSnapshot, this.fileSystemFactory.create(session));
                        return oldCached.withUpdatesApplied(newEntries, tableSnapshot.getVersion());
                    }
                    catch (MissingTransactionLogException newEntries) {
                        // empty catch block
                    }
                }
                List<AddFileEntry> activeFiles = this.loadActiveFiles(tableSnapshot, metadataEntry, protocolEntry, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()), session);
                return new DeltaLakeDataFileCacheEntry(tableSnapshot.getVersion(), activeFiles);
            });
            return cacheEntry.getActiveFiles();
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Failed accessing transaction log for table: " + tableSnapshot.getTable(), e);
        }
    }

    private List<AddFileEntry> loadActiveFiles(TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter, ConnectorSession session) {
        List list;
        block8: {
            List<Transaction> transactions = tableSnapshot.getTransactions();
            Stream<DeltaLakeTransactionLogEntry> checkpointEntries = tableSnapshot.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.ADD)), this.checkpointSchemaManager, this.typeManager, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats, Optional.of(new TableSnapshot.MetadataAndProtocolEntry(metadataEntry, protocolEntry)), partitionConstraint, addStatsMinMaxColumnFilter);
            try {
                list = (List)this.activeAddEntries(checkpointEntries, transactions).filter(partitionConstraint.isAll() ? addAction -> true : addAction -> DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), (Map)partitionConstraint.getDomains().orElseThrow())).collect(ImmutableList.toImmutableList());
                if (checkpointEntries == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (checkpointEntries != null) {
                        try {
                            checkpointEntries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error reading transaction log for " + tableSnapshot.getTable(), (Throwable)e);
                }
            }
            checkpointEntries.close();
        }
        return list;
    }

    public static List<DeltaLakeColumnMetadata> columnsWithStats(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        return TransactionLogAccess.columnsWithStats(DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, typeManager), metadataEntry.getOriginalPartitionColumns());
    }

    public static ImmutableList<DeltaLakeColumnMetadata> columnsWithStats(List<DeltaLakeColumnMetadata> schema, List<String> partitionColumns) {
        return (ImmutableList)schema.stream().filter(column -> !partitionColumns.contains(column.getName())).filter(column -> {
            Type type = column.getType();
            return !(type instanceof MapType) && !(type instanceof ArrayType) && !type.equals(BooleanType.BOOLEAN) && !type.equals(VarbinaryType.VARBINARY);
        }).collect(ImmutableList.toImmutableList());
    }

    private Stream<AddFileEntry> activeAddEntries(Stream<DeltaLakeTransactionLogEntry> checkpointEntries, List<Transaction> transactions) {
        LinkedHashMap activeJsonEntries = new LinkedHashMap();
        HashSet removedFiles = new HashSet();
        transactions.forEach(transaction -> {
            LinkedHashMap addFilesInTransaction = new LinkedHashMap();
            HashSet removedFilesInTransaction = new HashSet();
            transaction.transactionEntries().forEach(deltaLakeTransactionLogEntry -> {
                if (deltaLakeTransactionLogEntry.getAdd() != null) {
                    addFilesInTransaction.put(deltaLakeTransactionLogEntry.getAdd().getPath(), deltaLakeTransactionLogEntry.getAdd());
                } else if (deltaLakeTransactionLogEntry.getRemove() != null) {
                    removedFilesInTransaction.add(deltaLakeTransactionLogEntry.getRemove().getPath());
                }
            });
            removedFiles.addAll(removedFilesInTransaction);
            removedFilesInTransaction.forEach(activeJsonEntries::remove);
            activeJsonEntries.putAll(addFilesInTransaction);
        });
        Stream<AddFileEntry> filteredCheckpointEntries = checkpointEntries.map(DeltaLakeTransactionLogEntry::getAdd).filter(Objects::nonNull).filter(addEntry -> !removedFiles.contains(addEntry.getPath()) && !activeJsonEntries.containsKey(addEntry.getPath()));
        return Stream.concat(filteredCheckpointEntries, activeJsonEntries.values().stream());
    }

    public Stream<RemoveFileEntry> getRemoveEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.REMOVE, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    public Map<Class<?>, Object> getTransactionLogEntries(ConnectorSession session, TableSnapshot tableSnapshot, Set<CheckpointEntryIterator.EntryType> entryTypes, Function<Stream<DeltaLakeTransactionLogEntry>, Stream<Object>> entryMapper) {
        Stream entries = this.getEntries(tableSnapshot, entryTypes, (Stream<DeltaLakeTransactionLogEntry> checkpointStream, List<Transaction> jsonStream) -> (Stream)entryMapper.apply(Stream.concat(checkpointStream, jsonStream.stream().map(Transaction::transactionEntries).flatMap(Collection::stream))), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
        return (Map)entries.collect(ImmutableMap.toImmutableMap(Object::getClass, Function.identity(), (first, second) -> second));
    }

    public ProtocolEntry getProtocolEntry(ConnectorSession session, TableSnapshot tableSnapshot) {
        return this.getProtocolEntries(tableSnapshot, session).reduce((first, second) -> second).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol entry not found in transaction log for table " + tableSnapshot.getTable()));
    }

    public Stream<ProtocolEntry> getProtocolEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.PROTOCOL, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getProtocol).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    public Stream<CommitInfoEntry> getCommitInfoEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.COMMIT, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getCommitInfo).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    private <T> Stream<T> getEntries(TableSnapshot tableSnapshot, Set<CheckpointEntryIterator.EntryType> entryTypes, BiFunction<Stream<DeltaLakeTransactionLogEntry>, List<Transaction>, Stream<T>> entryMapper, ConnectorSession session, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) {
        try {
            List<Transaction> transactions = tableSnapshot.getTransactions();
            Stream<DeltaLakeTransactionLogEntry> checkpointEntries = tableSnapshot.getCheckpointTransactionLogEntries(session, entryTypes, this.checkpointSchemaManager, this.typeManager, fileSystem, stats, Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
            return entryMapper.apply(checkpointEntries, transactions);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error reading transaction log for " + tableSnapshot.getTable(), (Throwable)e);
        }
    }

    private <T> Stream<T> getEntries(TableSnapshot tableSnapshot, CheckpointEntryIterator.EntryType entryType, Function<Stream<DeltaLakeTransactionLogEntry>, Stream<T>> entryMapper, ConnectorSession session, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) {
        return this.getEntries(tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)entryType)), (Stream<DeltaLakeTransactionLogEntry> checkpointStream, List<Transaction> jsonStream) -> (Stream)entryMapper.apply(Stream.concat(checkpointStream, jsonStream.stream().map(Transaction::transactionEntries).flatMap(Collection::stream))), session, fileSystem, stats);
    }

    public Stream<DeltaLakeTransactionLogEntry> getJsonEntries(TrinoFileSystem fileSystem, String transactionLogDir, List<Long> forVersions) {
        return forVersions.stream().flatMap(version -> {
            try {
                Optional<List<DeltaLakeTransactionLogEntry>> entriesFromJson = TransactionLogTail.getEntriesFromJson(version, transactionLogDir, fileSystem);
                return entriesFromJson.map(Collection::stream).orElseGet(() -> Stream.of(new DeltaLakeTransactionLogEntry[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public List<Long> getPastTableVersions(TrinoFileSystem fileSystem, String transactionLogDir, Instant startAt, long lastVersion) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (long version = lastVersion; version >= 0L; --version) {
            Location entryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version);
            TrinoInputFile inputFile = fileSystem.newInputFile(entryPath);
            try {
                if (inputFile.lastModified().isBefore(startAt)) {
                    break;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            result.add((Object)version);
        }
        return result.build();
    }

    private static List<DeltaLakeTransactionLogEntry> getJsonEntries(long startVersion, long endVersion, TableSnapshot tableSnapshot, TrinoFileSystem fileSystem) throws IOException {
        Optional<Long> lastCheckpointVersion = tableSnapshot.getLastCheckpointVersion();
        if (lastCheckpointVersion.isPresent() && startVersion < lastCheckpointVersion.get()) {
            return ImmutableList.builder().addAll(TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), lastCheckpointVersion).getFileEntries()).addAll(tableSnapshot.getJsonTransactionLogEntries()).build();
        }
        return TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), Optional.of(endVersion)).getFileEntries();
    }

    public static String canonicalizeColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    public static <T> Map<CanonicalColumnName, T> toCanonicalNameKeyedMap(Map<String, T> map, Map<String, CanonicalColumnName> canonicalColumnNames) {
        return (Map)map.entrySet().stream().filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(entry -> Objects.requireNonNull((CanonicalColumnName)canonicalColumnNames.get(entry.getKey()), String.format("Did not find CanonicalColumnName for %s", entry.getKey())), Map.Entry::getValue));
    }

    @Deprecated
    public static <T> Map<String, T> toOriginalNameKeyedMap(Map<CanonicalColumnName, T> map) {
        return (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((CanonicalColumnName)entry.getKey()).getOriginalName(), Map.Entry::getValue));
    }

    private record TableLocation(SchemaTableName tableName, String location) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableLocation.class);

        TableLocation {
            Objects.requireNonNull(tableName, "tableName is null");
            Objects.requireNonNull(location, "location is null");
        }

        long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.tableName.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
        }
    }

    private record TableVersion(TableLocation tableLocation, long version) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableVersion.class);

        TableVersion {
            Objects.requireNonNull(tableLocation, "tableLocation is null");
        }

        long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.tableLocation.getRetainedSizeInBytes();
        }
    }

    private record QueriedTable(QueriedLocation queriedLocation, long version) {
        QueriedTable {
            Objects.requireNonNull(queriedLocation, "queriedLocation is null");
        }
    }

    private record QueriedLocation(String queryId, String tableLocation) {
        QueriedLocation {
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(tableLocation, "tableLocation is null");
        }
    }
}

