/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;

public class GcsTransactionLogSynchronizer
implements TransactionLogSynchronizer {
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public GcsTransactionLogSynchronizer(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Location newLogEntryPath, byte[] entryContents) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try (OutputStream outputStream = fileSystem.newOutputFile(newLogEntryPath).createExclusive();){
            outputStream.write(entryContents);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return false;
    }
}

