/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.openxjson;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OpenXJsonOptions {
    public static final OpenXJsonOptions DEFAULT_OPEN_X_JSON_OPTIONS = OpenXJsonOptions.builder().build();
    static final ImmutableList<String> HIVE_SERDE_CLASS_NAMES = ImmutableList.of((Object)"org.openx.data.jsonserde.JsonSerDe");
    private static final String CASE_INSENSITIVE_KEY = "case.insensitive";
    private static final String FIELD_MAPPING_KEY_PREFIX = "mapping.";
    private static final String IGNORE_MALFORMED_JSON_KEY = "ignore.malformed.json";
    private static final String DOTS_IN_FIELD_NAMES_KEY = "dots.in.keys";
    private static final String EXPLICIT_NULL_KEY = "explicit.null";
    private static final String TIMESTAMP_FORMATS_KEY = "timestamp.formats";
    private final boolean ignoreMalformedJson;
    private final Map<String, String> fieldNameMappings;
    private final boolean caseInsensitive;
    private final boolean dotsInFieldNames;
    private final boolean explicitNull;
    private final List<String> timestampFormats;

    private OpenXJsonOptions(boolean ignoreMalformedJson, Map<String, String> fieldNameMappings, boolean caseInsensitive, boolean dotsInFieldNames, boolean explicitNull, List<String> timestampFormats) {
        this.ignoreMalformedJson = ignoreMalformedJson;
        this.fieldNameMappings = ImmutableMap.copyOf(fieldNameMappings);
        this.caseInsensitive = caseInsensitive;
        this.dotsInFieldNames = dotsInFieldNames;
        this.explicitNull = explicitNull;
        this.timestampFormats = ImmutableList.copyOf(timestampFormats);
    }

    public boolean isIgnoreMalformedJson() {
        return this.ignoreMalformedJson;
    }

    public Map<String, String> getFieldNameMappings() {
        return this.fieldNameMappings;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isDotsInFieldNames() {
        return this.dotsInFieldNames;
    }

    public boolean isExplicitNull() {
        return this.explicitNull;
    }

    public List<String> getTimestampFormats() {
        return this.timestampFormats;
    }

    public Map<String, String> toSchema() {
        ImmutableMap.Builder schema = ImmutableMap.builder();
        if (this.ignoreMalformedJson) {
            schema.put((Object)IGNORE_MALFORMED_JSON_KEY, (Object)"true");
        }
        if (!this.caseInsensitive) {
            schema.put((Object)CASE_INSENSITIVE_KEY, (Object)"false");
        }
        for (Map.Entry<String, String> entry : this.fieldNameMappings.entrySet()) {
            schema.put((Object)(FIELD_MAPPING_KEY_PREFIX + entry.getKey()), (Object)entry.getValue());
        }
        if (this.dotsInFieldNames) {
            schema.put((Object)DOTS_IN_FIELD_NAMES_KEY, (Object)"true");
        }
        if (this.explicitNull) {
            schema.put((Object)EXPLICIT_NULL_KEY, (Object)"true");
        }
        if (!this.timestampFormats.isEmpty()) {
            schema.put((Object)TIMESTAMP_FORMATS_KEY, (Object)String.join((CharSequence)",", this.timestampFormats));
        }
        return schema.buildOrThrow();
    }

    public static OpenXJsonOptions fromSchema(Map<String, String> serdeProperties) {
        String timestampFormats;
        boolean caseInsensitive;
        Builder builder = OpenXJsonOptions.builder();
        if ("true".equalsIgnoreCase(serdeProperties.get(IGNORE_MALFORMED_JSON_KEY))) {
            builder.ignoreMalformedJson();
        }
        if (!(caseInsensitive = "true".equalsIgnoreCase(serdeProperties.getOrDefault(CASE_INSENSITIVE_KEY, "true")))) {
            builder.caseSensitive();
        }
        for (Map.Entry<String, String> entry : serdeProperties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(FIELD_MAPPING_KEY_PREFIX)) continue;
            String hiveField = key.substring(FIELD_MAPPING_KEY_PREFIX.length());
            String jsonField = caseInsensitive ? entry.getValue().toLowerCase(Locale.ROOT) : entry.getValue();
            builder.addFieldMapping(hiveField, jsonField);
        }
        if ("true".equalsIgnoreCase(serdeProperties.get(DOTS_IN_FIELD_NAMES_KEY))) {
            builder.dotsInFieldNames();
        }
        if ("true".equalsIgnoreCase(serdeProperties.get(EXPLICIT_NULL_KEY))) {
            builder.explicitNull();
        }
        if ((timestampFormats = serdeProperties.get(TIMESTAMP_FORMATS_KEY)) != null) {
            builder.timestampFormats(Splitter.on((char)',').splitToList((CharSequence)timestampFormats));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenXJsonOptions options) {
        return new Builder(options);
    }

    public static class Builder {
        private boolean ignoreMalformedJson;
        private boolean caseInsensitive = true;
        private final ImmutableMap.Builder<String, String> fieldNameMappings = ImmutableMap.builder();
        private boolean dotsInFieldNames;
        private boolean explicitNull;
        private List<String> timestampFormats = ImmutableList.of();

        public Builder() {
        }

        private Builder(OpenXJsonOptions options) {
            this.ignoreMalformedJson = options.isIgnoreMalformedJson();
            this.caseInsensitive = options.isCaseInsensitive();
            this.fieldNameMappings.putAll(options.getFieldNameMappings());
            this.dotsInFieldNames = options.isDotsInFieldNames();
            this.explicitNull = options.isExplicitNull();
            this.timestampFormats = options.getTimestampFormats();
        }

        public Builder ignoreMalformedJson() {
            this.ignoreMalformedJson = true;
            return this;
        }

        public Builder addFieldMapping(String hiveField, String jsonField) {
            this.fieldNameMappings.put((Object)hiveField, (Object)jsonField);
            return this;
        }

        public Builder caseSensitive() {
            this.caseInsensitive = false;
            return this;
        }

        public Builder dotsInFieldNames() {
            this.dotsInFieldNames = true;
            return this;
        }

        public Builder explicitNull() {
            this.explicitNull = true;
            return this;
        }

        public Builder timestampFormats(String ... timestampFormats) {
            return this.timestampFormats((List<String>)ImmutableList.copyOf((Object[])timestampFormats));
        }

        public Builder timestampFormats(List<String> timestampFormats) {
            this.timestampFormats = timestampFormats;
            return this;
        }

        public OpenXJsonOptions build() {
            return new OpenXJsonOptions(this.ignoreMalformedJson, (Map<String, String>)this.fieldNameMappings.buildOrThrow(), this.caseInsensitive, this.dotsInFieldNames, this.explicitNull, this.timestampFormats);
        }
    }
}

