/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.base.Versions;
import io.trino.plugin.deltalake.InternalDeltaLakeConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeConnectorFactory
implements ConnectorFactory {
    public static final String CONNECTOR_NAME = "delta_lake";
    private final Module module;

    public DeltaLakeConnectorFactory() {
        this(Modules.EMPTY_MODULE);
    }

    public DeltaLakeConnectorFactory(Module module) {
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return CONNECTOR_NAME;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        return InternalDeltaLakeConnectorFactory.createConnector(catalogName, config, context, Optional.empty(), Optional.empty(), this.module);
    }
}

