/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DeltaLakeOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String schemaName;
    private final String tableName;
    private final List<DeltaLakeColumnHandle> inputColumns;
    private final String location;
    private final Optional<Long> checkpointInterval;
    private final boolean external;
    private final Optional<String> comment;
    private final Optional<Boolean> changeDataFeedEnabled;
    private final DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode;
    private final OptionalInt maxColumnId;
    private final String schemaString;
    private final ProtocolEntry protocolEntry;

    @JsonCreator
    public DeltaLakeOutputTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="inputColumns") List<DeltaLakeColumnHandle> inputColumns, @JsonProperty(value="location") String location, @JsonProperty(value="checkpointInterval") Optional<Long> checkpointInterval, @JsonProperty(value="external") boolean external, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="changeDataFeedEnabled") Optional<Boolean> changeDataFeedEnabled, @JsonProperty(value="schemaString") String schemaString, @JsonProperty(value="columnMappingMode") DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, @JsonProperty(value="maxColumnId") OptionalInt maxColumnId, @JsonProperty(value="protocolEntry") ProtocolEntry protocolEntry) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.inputColumns = ImmutableList.copyOf(inputColumns);
        this.location = Objects.requireNonNull(location, "location is null");
        this.checkpointInterval = checkpointInterval;
        this.external = external;
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.changeDataFeedEnabled = Objects.requireNonNull(changeDataFeedEnabled, "changeDataFeedEnabled is null");
        this.schemaString = Objects.requireNonNull(schemaString, "schemaString is null");
        this.columnMappingMode = Objects.requireNonNull(columnMappingMode, "columnMappingMode is null");
        this.maxColumnId = Objects.requireNonNull(maxColumnId, "maxColumnId is null");
        this.protocolEntry = Objects.requireNonNull(protocolEntry, "protocolEntry is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<DeltaLakeColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonIgnore
    public List<String> getPartitionedBy() {
        return (List)this.getInputColumns().stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.PARTITION_KEY).map(DeltaLakeColumnHandle::getColumnName).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty
    public Optional<Long> getCheckpointInterval() {
        return this.checkpointInterval;
    }

    @JsonProperty
    public boolean isExternal() {
        return this.external;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Optional<Boolean> getChangeDataFeedEnabled() {
        return this.changeDataFeedEnabled;
    }

    @JsonProperty
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty
    public DeltaLakeSchemaSupport.ColumnMappingMode getColumnMappingMode() {
        return this.columnMappingMode;
    }

    @JsonProperty
    public OptionalInt getMaxColumnId() {
        return this.maxColumnId;
    }

    @JsonProperty
    public ProtocolEntry getProtocolEntry() {
        return this.protocolEntry;
    }
}

