/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableProcedureId;
import io.trino.plugin.deltalake.procedure.DeltaTableProcedureHandle;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class DeltaLakeTableExecuteHandle
implements ConnectorTableExecuteHandle {
    private final SchemaTableName schemaTableName;
    private final DeltaLakeTableProcedureId procedureId;
    private final DeltaTableProcedureHandle procedureHandle;
    private final String tableLocation;

    @JsonCreator
    public DeltaLakeTableExecuteHandle(SchemaTableName schemaTableName, DeltaLakeTableProcedureId procedureId, DeltaTableProcedureHandle procedureHandle, String tableLocation) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.procedureId = Objects.requireNonNull(procedureId, "procedureId is null");
        this.procedureHandle = Objects.requireNonNull(procedureHandle, "procedureHandle is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public DeltaLakeTableProcedureId getProcedureId() {
        return this.procedureId;
    }

    @JsonProperty
    public DeltaTableProcedureHandle getProcedureHandle() {
        return this.procedureHandle;
    }

    @JsonProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    public DeltaLakeTableExecuteHandle withProcedureHandle(DeltaTableProcedureHandle procedureHandle) {
        return new DeltaLakeTableExecuteHandle(this.schemaTableName, this.procedureId, procedureHandle, this.tableLocation);
    }
}

