/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.base.util.UncheckedCloseable;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RegisterTableProcedure
implements Provider<Procedure> {
    private static final MethodHandle REGISTER_TABLE;
    private static final String PROCEDURE_NAME = "register_table";
    private static final String SYSTEM_SCHEMA = "system";
    private static final String SCHEMA_NAME = "SCHEMA_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_LOCATION = "TABLE_LOCATION";
    private final DeltaLakeMetadataFactory metadataFactory;
    private final TransactionLogAccess transactionLogAccess;
    private final CachingExtendedStatisticsAccess statisticsAccess;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final boolean registerTableProcedureEnabled;

    @Inject
    public RegisterTableProcedure(DeltaLakeMetadataFactory metadataFactory, TransactionLogAccess transactionLogAccess, CachingExtendedStatisticsAccess statisticsAccess, TrinoFileSystemFactory fileSystemFactory, DeltaLakeConfig deltaLakeConfig) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.registerTableProcedureEnabled = deltaLakeConfig.isRegisterTableProcedureEnabled();
    }

    public Procedure get() {
        return new Procedure(SYSTEM_SCHEMA, PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(SCHEMA_NAME, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(TABLE_NAME, (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument(TABLE_LOCATION, (Type)VarcharType.VARCHAR)), REGISTER_TABLE.bindTo(this));
    }

    public void registerTable(ConnectorSession clientSession, String schemaName, String tableName, String tableLocation) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doRegisterTable(clientSession, schemaName, tableName, tableLocation);
        }
    }

    private void doRegisterTable(ConnectorSession session, String schemaName, String tableName, String tableLocation) {
        if (!this.registerTableProcedureEnabled) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "register_table procedure is disabled");
        }
        Procedures.checkProcedureArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (String)"schema_name cannot be null or empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (String)"table_name cannot be null or empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!Strings.isNullOrEmpty((String)tableLocation) ? 1 : 0) != 0, (String)"table_location cannot be null or empty", (Object[])new Object[0]);
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        DeltaLakeMetadata metadata = this.metadataFactory.create(session.getIdentity());
        metadata.beginQuery(session);
        try (UncheckedCloseable ignore = () -> metadata.cleanupQuery(session);){
            DeltaLakeMetastore metastore = metadata.getMetastore();
            if (metastore.getDatabase(schemaName).isEmpty()) {
                throw new SchemaNotFoundException(schemaTableName.getSchemaName());
            }
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try {
                Location transactionLogDir = Location.of((String)TransactionLogUtil.getTransactionLogDir(tableLocation));
                if (!fileSystem.listFiles(transactionLogDir).hasNext()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("No transaction log found in location %s", transactionLogDir));
                }
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, String.format("Failed checking table location %s", tableLocation), (Throwable)e);
            }
            Table table = DeltaLakeMetadata.buildTable(session, schemaTableName, tableLocation, true);
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
            this.statisticsAccess.invalidateCache(schemaTableName, Optional.of(tableLocation));
            this.transactionLogAccess.invalidateCache(schemaTableName, Optional.of(tableLocation));
            try {
                TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(session, table.getSchemaTableName(), tableLocation);
                this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (IOException | RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_TABLE, "Failed to access table location: " + tableLocation, (Throwable)e);
            }
            String queryId = session.getQueryId();
            Verify.verify((boolean)DeltaLakeMetadata.getQueryId(table).orElseThrow(() -> new IllegalArgumentException("Query id is not present")).equals(queryId), (String)"Table '%s' does not have correct query id set", (Object)table);
            metastore.createTable(session, table, principalPrivileges);
        }
    }

    static {
        try {
            REGISTER_TABLE = MethodHandles.lookup().unreflect(RegisterTableProcedure.class.getMethod("registerTable", ConnectorSession.class, String.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

