/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;

public final class PageListBuilder {
    private final int channels;
    private final PageBuilder pageBuilder;
    private ImmutableList.Builder<Page> pages;
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.channels = types.size();
        this.pageBuilder = new PageBuilder(types);
        this.reset();
    }

    public void reset() {
        this.pages = ImmutableList.builder();
        this.pageBuilder.reset();
        this.channel = -1;
    }

    public List<Page> build() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"cannot be in row");
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        Preconditions.checkArgument((this.channel == -1 ? 1 : 0) != 0, (Object)"already in row");
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public void endRow() {
        Preconditions.checkArgument((this.channel == this.channels ? 1 : 0) != 0, (Object)"not at end of row");
        this.channel = -1;
    }

    public void appendNull() {
        this.nextColumn().appendNull();
    }

    public void appendBigint(long value) {
        BigintType.BIGINT.writeLong(this.nextColumn(), value);
    }

    public void appendBoolean(boolean value) {
        BooleanType.BOOLEAN.writeBoolean(this.nextColumn(), value);
    }

    public void appendTimestampTzMillis(long millisUtc, TimeZoneKey timeZoneKey) {
        TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.writeLong(this.nextColumn(), DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
    }

    public void appendVarchar(String value) {
        VarcharType.VARCHAR.writeString(this.nextColumn(), value);
    }

    public void appendVarcharVarcharMap(Map<String, String> values) {
        MapBlockBuilder column = (MapBlockBuilder)this.nextColumn();
        column.buildEntry((keyBuilder, valueBuilder) -> values.forEach((key, value) -> {
            if (key == null) {
                keyBuilder.appendNull();
            } else {
                VarcharType.VARCHAR.writeString(keyBuilder, key);
            }
            if (value == null) {
                valueBuilder.appendNull();
            } else {
                VarcharType.VARCHAR.writeString(valueBuilder, value);
            }
        }));
    }

    public BlockBuilder nextColumn() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }

    public static PageListBuilder forTable(ConnectorTableMetadata table) {
        return new PageListBuilder((List)table.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList()));
    }
}

