/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class GcsFileSystemConfig {
    private DataSize readBlockSize = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize writeBlockSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int pageSize = 100;
    private int batchSize = 100;
    private String projectId;
    private boolean useGcsAccessToken;
    private String jsonKey;
    private String jsonKeyFilePath;
    private int maxRetries = 20;
    private double backoffScaleFactor = 2.0;
    private Duration maxRetryTime = new Duration(20.0, TimeUnit.SECONDS);
    private Duration minBackoffDelay = new Duration(10.0, TimeUnit.MILLISECONDS);
    private Duration maxBackoffDelay = new Duration(1100.0, TimeUnit.MILLISECONDS);

    @NotNull
    public DataSize getReadBlockSize() {
        return this.readBlockSize;
    }

    @Config(value="gcs.read-block-size")
    @ConfigDescription(value="Minimum size that will be read in one RPC. The default size is 2MiB, see com.google.cloud.BaseStorageReadChannel.")
    public GcsFileSystemConfig setReadBlockSize(DataSize readBlockSize) {
        this.readBlockSize = readBlockSize;
        return this;
    }

    @NotNull
    public DataSize getWriteBlockSize() {
        return this.writeBlockSize;
    }

    @Config(value="gcs.write-block-size")
    @ConfigDescription(value="Minimum size that will be written in one RPC. The default size is 16MiB, see com.google.cloud.BaseStorageWriteChannel.")
    public GcsFileSystemConfig setWriteBlockSize(DataSize writeBlockSize) {
        this.writeBlockSize = writeBlockSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPageSize() {
        return this.pageSize;
    }

    @Config(value="gcs.page-size")
    @ConfigDescription(value="The maximum number of blobs to return per page.")
    public GcsFileSystemConfig setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getBatchSize() {
        return this.batchSize;
    }

    @Config(value="gcs.batch-size")
    @ConfigDescription(value="Number of blobs to delete per batch. Recommended batch size is 100: https://cloud.google.com/storage/docs/batch")
    public GcsFileSystemConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Config(value="gcs.project-id")
    public GcsFileSystemConfig setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public boolean isUseGcsAccessToken() {
        return this.useGcsAccessToken;
    }

    @Config(value="gcs.use-access-token")
    public GcsFileSystemConfig setUseGcsAccessToken(boolean useGcsAccessToken) {
        this.useGcsAccessToken = useGcsAccessToken;
        return this;
    }

    @Nullable
    public String getJsonKey() {
        return this.jsonKey;
    }

    @Config(value="gcs.json-key")
    @ConfigSecuritySensitive
    public GcsFileSystemConfig setJsonKey(String jsonKey) {
        this.jsonKey = jsonKey;
        return this;
    }

    @Nullable
    @FileExists
    public String getJsonKeyFilePath() {
        return this.jsonKeyFilePath;
    }

    @Config(value="gcs.json-key-file-path")
    @ConfigDescription(value="JSON key file used to access Google Cloud Storage")
    public GcsFileSystemConfig setJsonKeyFilePath(String jsonKeyFilePath) {
        this.jsonKeyFilePath = jsonKeyFilePath;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxRetries() {
        return this.maxRetries;
    }

    @Config(value="gcs.client.max-retries")
    @ConfigDescription(value="Maximum number of RPC attempts")
    public GcsFileSystemConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) double getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    @Config(value="gcs.client.backoff-scale-factor")
    @ConfigDescription(value="Scale factor for RPC retry delay")
    public GcsFileSystemConfig setBackoffScaleFactor(double backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="gcs.client.max-retry-time")
    @ConfigDescription(value="Total time limit for an RPC to be retried")
    public GcsFileSystemConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMinBackoffDelay() {
        return this.minBackoffDelay;
    }

    @Config(value="gcs.client.min-backoff-delay")
    @ConfigDescription(value="Minimum delay between RPC retries")
    public GcsFileSystemConfig setMinBackoffDelay(Duration minBackoffDelay) {
        this.minBackoffDelay = minBackoffDelay;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMaxBackoffDelay() {
        return this.maxBackoffDelay;
    }

    @Config(value="gcs.client.max-backoff-delay")
    @ConfigDescription(value="Maximum delay between RPC retries.")
    public GcsFileSystemConfig setMaxBackoffDelay(Duration maxBackoffDelay) {
        this.maxBackoffDelay = maxBackoffDelay;
        return this;
    }

    @AssertTrue(message="gcs.client.min-backoff-delay must be less than or equal to gcs.client.max-backoff-delay")
    public @AssertTrue(message="gcs.client.min-backoff-delay must be less than or equal to gcs.client.max-backoff-delay") boolean isRetryDelayValid() {
        return this.minBackoffDelay.compareTo(this.maxBackoffDelay) <= 0;
    }

    public void validate() {
        if (this.useGcsAccessToken) {
            Preconditions.checkState((this.jsonKey == null ? 1 : 0) != 0, (Object)"Cannot specify 'gcs.json-key' when 'gcs.use-access-token' is set");
            Preconditions.checkState((this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"Cannot specify 'gcs.json-key-file-path' when 'gcs.use-access-token' is set");
        }
        Preconditions.checkState((this.jsonKey == null || this.jsonKeyFilePath == null ? 1 : 0) != 0, (Object)"'gcs.json-key' and 'gcs.json-key-file-path' cannot be both set");
    }
}

