/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TryExpression
extends Expression {
    private final Expression innerExpression;

    public TryExpression(Expression innerExpression) {
        this(Optional.empty(), innerExpression);
    }

    public TryExpression(NodeLocation location, Expression innerExpression) {
        this(Optional.of(location), innerExpression);
    }

    private TryExpression(Optional<NodeLocation> location, Expression innerExpression) {
        super(location);
        this.innerExpression = Objects.requireNonNull(innerExpression, "innerExpression is null");
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTryExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.innerExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryExpression o = (TryExpression)obj;
        return Objects.equals(this.innerExpression, o.innerExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerExpression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return TryExpression.sameClass(this, other);
    }
}

