/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.linkedin.coral.common.ToRelConverter;
import com.linkedin.coral.common.functions.GenericProjectFunction;
import com.linkedin.coral.common.utils.RelDataTypeToHiveTypeStringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;

public class FuzzyUnionSqlRewriter
extends SqlShuttle {
    private final String tableName;
    private final ToRelConverter toRelConverter;

    public FuzzyUnionSqlRewriter(@Nonnull String tableName, @Nonnull ToRelConverter toRelConverter) {
        this.toRelConverter = toRelConverter;
        this.tableName = tableName;
    }

    @Override
    public SqlNode visit(SqlCall call) {
        if (call.getOperator().getKind() == SqlKind.UNION) {
            RelDataType expectedDataType = this.getUnionDataType(call);
            this.addFuzzyUnionToUnionCall(call, expectedDataType);
        }
        return super.visit(call);
    }

    private SqlNode createGenericProject(String columnName, RelDataType expectedType) {
        SqlNode[] genericProjectOperands = new SqlNode[3];
        genericProjectOperands[0] = new SqlIdentifier((List<String>)ImmutableList.of((Object)this.tableName, (Object)columnName), SqlParserPos.ZERO);
        genericProjectOperands[1] = SqlLiteral.createCharString(columnName, SqlParserPos.ZERO);
        String expectedHiveTypeString = RelDataTypeToHiveTypeStringConverter.convertRelDataType(expectedType);
        genericProjectOperands[2] = SqlLiteral.createCharString(expectedHiveTypeString, SqlParserPos.ZERO);
        SqlBasicCall genericProjectCall = new SqlBasicCall(new GenericProjectFunction(expectedType), genericProjectOperands, SqlParserPos.ZERO);
        SqlNode[] castAsColumnOperands = new SqlNode[]{genericProjectCall, new SqlIdentifier(columnName, SqlParserPos.ZERO)};
        SqlBasicCall castAsCall = new SqlBasicCall(new SqlAsOperator(), castAsColumnOperands, SqlParserPos.ZERO);
        return castAsCall;
    }

    private SqlNodeList createProjectedFieldsNodeList(RelDataType fromNodeDataType, RelDataType expectedDataType) {
        SqlNodeList projectedFields = new SqlNodeList(SqlParserPos.ZERO);
        for (RelDataTypeField expectedField : expectedDataType.getFieldList()) {
            RelDataTypeField inputField = fromNodeDataType.getField(expectedField.getName(), false, false);
            SqlNode projectedField = new SqlIdentifier((List<String>)ImmutableList.of((Object)this.tableName, (Object)inputField.getName()), SqlParserPos.ZERO);
            if (!this.equivalentDataTypes(expectedField.getType(), inputField.getType())) {
                projectedField = this.createGenericProject(inputField.getName(), expectedField.getType());
            }
            projectedFields.add(projectedField);
        }
        return projectedFields;
    }

    private SqlNode addFuzzyUnionToUnionBranch(SqlNode unionBranch, RelDataType expectedDataType) {
        RelDataType fromNodeDataType = this.toRelConverter.getSqlToRelConverter().convertQuery((SqlNode)unionBranch.accept(new FuzzyUnionSqlRewriter((String)this.tableName, (ToRelConverter)this.toRelConverter)), (boolean)true, (boolean)true).rel.getRowType();
        SqlNodeList projectedFields = this.createProjectedFieldsNodeList(fromNodeDataType, expectedDataType);
        SqlNode[] castTableOperands = new SqlNode[]{unionBranch, new SqlIdentifier(this.tableName, SqlParserPos.ZERO)};
        SqlBasicCall castTableCall = new SqlBasicCall(new SqlAsOperator(), castTableOperands, SqlParserPos.ZERO);
        SqlSelect selectOperator = new SqlSelect(SqlParserPos.ZERO, new SqlNodeList(SqlParserPos.ZERO), projectedFields, castTableCall, null, null, null, null, null, null, null);
        return selectOperator;
    }

    private SqlCall addFuzzyUnionToUnionCall(SqlCall unionCall, RelDataType expectedDataType) {
        for (int i = 0; i < unionCall.operandCount(); ++i) {
            Object operand = unionCall.operand(i);
            if (!this.isUnionOperator((SqlNode)operand)) {
                unionCall.setOperand(i, this.addFuzzyUnionToUnionBranch((SqlNode)operand, expectedDataType));
                continue;
            }
            unionCall.setOperand(i, this.addFuzzyUnionToUnionCall((SqlCall)operand, expectedDataType));
        }
        return unionCall;
    }

    private RelDataType getUnionDataType(SqlCall unionCall) {
        List<SqlNode> leafNodes = this.getUnionLeafNodes(unionCall);
        ArrayList<RelDataType> leafNodeDataTypes = new ArrayList<RelDataType>();
        for (SqlNode node : leafNodes) {
            RelDataType fromNodeDataType = this.toRelConverter.getSqlValidator().getValidatedNodeTypeIfKnown(node);
            if (fromNodeDataType == null) {
                this.toRelConverter.getSqlValidator().validate(node.accept(new FuzzyUnionSqlRewriter(this.tableName, this.toRelConverter)));
                fromNodeDataType = this.toRelConverter.getSqlValidator().getValidatedNodeType(node);
            }
            leafNodeDataTypes.add(fromNodeDataType);
        }
        return this.getUnionDataType(leafNodeDataTypes);
    }

    private RelDataType getUnionDataType(List<RelDataType> dataTypes) {
        RelDataType baseDataType = dataTypes.get(0);
        if (!baseDataType.isStruct() && baseDataType.getSqlTypeName() != SqlTypeName.ARRAY && baseDataType.getSqlTypeName() != SqlTypeName.MAP) {
            return this.toRelConverter.getRelBuilder().getTypeFactory().createTypeWithNullability(baseDataType, true);
        }
        RelDataType expectedCommonType = null;
        if (baseDataType.isStruct()) {
            RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(this.toRelConverter.getRelBuilder().getTypeFactory());
            Sets.SetView commonFieldNames = baseDataType.getFieldNames().stream().map(String::toLowerCase).collect(Collectors.toSet());
            for (int i = 1; i < dataTypes.size(); ++i) {
                Set branchFieldNames = dataTypes.get(i).getFieldNames().stream().map(String::toLowerCase).collect(Collectors.toSet());
                commonFieldNames = Sets.intersection(commonFieldNames, branchFieldNames);
            }
            for (RelDataTypeField field : baseDataType.getFieldList()) {
                if (!commonFieldNames.contains(field.getName().toLowerCase())) continue;
                List<RelDataType> fieldTypes = dataTypes.stream().map(type -> type.getField(field.getName(), false, false).getType()).collect(Collectors.toList());
                RelDataType columnType = this.getUnionDataType(fieldTypes);
                builder.add(field.getName(), this.toRelConverter.getRelBuilder().getTypeFactory().createTypeWithNullability(columnType, true));
            }
            expectedCommonType = this.toRelConverter.getRelBuilder().getTypeFactory().createTypeWithNullability(builder.build(), true);
        }
        if (baseDataType.getSqlTypeName() == SqlTypeName.ARRAY) {
            List<RelDataType> nestedArrayTypes = dataTypes.stream().map(RelDataType::getComponentType).collect(Collectors.toList());
            RelDataType expectedArrayType = this.getUnionDataType(nestedArrayTypes);
            expectedCommonType = this.toRelConverter.getRelBuilder().getTypeFactory().createArrayType(expectedArrayType, -1L);
        }
        if (baseDataType.getSqlTypeName() == SqlTypeName.MAP) {
            List<RelDataType> nestedValueTypes = dataTypes.stream().map(RelDataType::getValueType).collect(Collectors.toList());
            RelDataType expectedValueType = this.getUnionDataType(nestedValueTypes);
            RelDataType expectedKeyType = this.toRelConverter.getRelBuilder().getTypeFactory().createTypeWithNullability(baseDataType.getKeyType(), true);
            expectedCommonType = this.toRelConverter.getRelBuilder().getTypeFactory().createMapType(expectedKeyType, expectedValueType);
        }
        return expectedCommonType;
    }

    private List<SqlNode> getUnionLeafNodes(SqlCall unionCall) {
        ArrayList<SqlNode> leafNodes = new ArrayList<SqlNode>();
        for (int i = 0; i < unionCall.operandCount(); ++i) {
            Object operand = unionCall.operand(i);
            if (this.isUnionOperator((SqlNode)operand)) {
                leafNodes.addAll(this.getUnionLeafNodes((SqlCall)operand));
                continue;
            }
            leafNodes.add((SqlNode)operand);
        }
        return leafNodes;
    }

    private boolean isUnionOperator(SqlNode node) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator().getKind() == SqlKind.UNION;
    }

    private boolean equivalentDataTypes(RelDataType t1, RelDataType t2) {
        if (t1.isStruct()) {
            if (t1.getFieldCount() != t2.getFieldCount()) {
                return false;
            }
            for (int i = 0; i < t1.getFieldCount(); ++i) {
                RelDataTypeField f1 = t1.getFieldList().get(i);
                RelDataTypeField f2 = t2.getFieldList().get(i);
                if (f1.getName().equalsIgnoreCase(f2.getName()) && this.equivalentDataTypes(f1.getType(), f2.getType())) continue;
                return false;
            }
        }
        if (t1.getSqlTypeName() == SqlTypeName.ARRAY && !this.equivalentDataTypes(t1.getComponentType(), t2.getComponentType())) {
            return false;
        }
        return t1.getSqlTypeName() != SqlTypeName.MAP || this.equivalentDataTypes(t1.getValueType(), t2.getValueType());
    }
}

