/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.transformers.SqlCallTransformers;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import com.linkedin.coral.trino.rel2trino.transformers.ConcatOperatorTransformer;
import com.linkedin.coral.trino.rel2trino.transformers.FromUtcTimestampOperatorTransformer;
import com.linkedin.coral.trino.rel2trino.transformers.GenericProjectTransformer;
import com.linkedin.coral.trino.rel2trino.transformers.NamedStructToCastTransformer;
import com.linkedin.coral.trino.rel2trino.transformers.SubstrOperatorTransformer;
import com.linkedin.coral.trino.rel2trino.transformers.UnionSqlCallTransformer;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlShuttle;

public class DataTypeDerivedSqlCallConverter
extends SqlShuttle {
    private final SqlCallTransformers operatorTransformerList;
    private final HiveToRelConverter toRelConverter;

    public DataTypeDerivedSqlCallConverter(HiveMetastoreClient mscClient, SqlNode topSqlNode) {
        this.toRelConverter = new HiveToRelConverter(mscClient);
        topSqlNode.accept(new RegisterDynamicFunctionsForTypeDerivation());
        TypeDerivationUtil typeDerivationUtil = new TypeDerivationUtil(this.toRelConverter.getSqlValidator(), topSqlNode);
        this.operatorTransformerList = SqlCallTransformers.of(new FromUtcTimestampOperatorTransformer(typeDerivationUtil), new GenericProjectTransformer(typeDerivationUtil), new NamedStructToCastTransformer(typeDerivationUtil), new ConcatOperatorTransformer(typeDerivationUtil), new SubstrOperatorTransformer(typeDerivationUtil), new UnionSqlCallTransformer(typeDerivationUtil));
    }

    @Override
    public SqlNode visit(SqlCall call) {
        return this.operatorTransformerList.apply((SqlCall)super.visit(call));
    }

    private class RegisterDynamicFunctionsForTypeDerivation
    extends SqlShuttle {
        private RegisterDynamicFunctionsForTypeDerivation() {
        }

        @Override
        public SqlNode visit(SqlCall sqlCall) {
            if (sqlCall instanceof SqlBasicCall && sqlCall.getOperator() instanceof VersionedSqlUserDefinedFunction && sqlCall.getOperator().getName().contains(".")) {
                Function function = new Function(sqlCall.getOperator().getName(), sqlCall.getOperator());
                DataTypeDerivedSqlCallConverter.this.toRelConverter.getFunctionResolver().addDynamicFunctionToTheRegistry(sqlCall.getOperator().getName(), function);
            }
            return super.visit(sqlCall);
        }
    }
}

