/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class MapValueConstructorTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator() instanceof SqlMapValueConstructor;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> sourceOperands = sqlCall.getOperandList();
        ArrayList<SqlCall> updatedOperands = new ArrayList<SqlCall>();
        ArrayList<SqlNode> keys = new ArrayList<SqlNode>();
        for (int i = 0; i < sourceOperands.size(); i += 2) {
            keys.add(sourceOperands.get(i));
        }
        updatedOperands.add(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, keys));
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (int i = 1; i < sourceOperands.size(); i += 2) {
            values.add(sourceOperands.get(i));
        }
        updatedOperands.add(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, values));
        return sqlCall.getOperator().createCall(SqlParserPos.ZERO, updatedOperands);
    }
}

