/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SubstrOperatorTransformer
extends SqlCallTransformer {
    private static final int DEFAULT_VARCHAR_PRECISION = new HiveTypeSystem().getDefaultPrecision(SqlTypeName.VARCHAR);
    private static final String SUBSTR_OPERATOR_NAME = "substr";
    private static final Set<SqlTypeName> OPERAND_SQL_TYPE_NAMES = new HashSet<SqlTypeName>(Arrays.asList(SqlTypeName.VARCHAR, SqlTypeName.CHAR));
    private static final SqlDataTypeSpec VARCHAR_SQL_DATA_TYPE_SPEC = new SqlDataTypeSpec(new SqlBasicTypeNameSpec(SqlTypeName.VARCHAR, DEFAULT_VARCHAR_PRECISION, SqlParserPos.ZERO), SqlParserPos.ZERO);

    public SubstrOperatorTransformer(TypeDerivationUtil typeDerivationUtil) {
        super(typeDerivationUtil);
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getName().equalsIgnoreCase(SUBSTR_OPERATOR_NAME);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> operands = sqlCall.getOperandList();
        RelDataType relDataTypeOfOperand = this.deriveRelDatatype(operands.get(0));
        if (!OPERAND_SQL_TYPE_NAMES.contains((Object)relDataTypeOfOperand.getSqlTypeName())) {
            ArrayList<SqlNode> modifiedOperands = new ArrayList<SqlNode>();
            modifiedOperands.add(SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, operands.get(0), VARCHAR_SQL_DATA_TYPE_SPEC));
            modifiedOperands.addAll(operands.subList(1, operands.size()));
            return sqlCall.getOperator().createCall(SqlParserPos.ZERO, modifiedOperands);
        }
        return sqlCall;
    }
}

