/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducerManager;
import io.opentelemetry.opencensusshim.internal.metrics.MetricAdapter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;

public final class OpenCensusMetricProducer
implements MetricProducer {
    private final MetricProducerManager openCensusMetricStorage;

    OpenCensusMetricProducer(MetricProducerManager openCensusMetricStorage) {
        this.openCensusMetricStorage = openCensusMetricStorage;
    }

    public static MetricProducer create() {
        return new OpenCensusMetricProducer(Metrics.getExportComponent().getMetricProducerManager());
    }

    public Collection<MetricData> produce(Resource resource) {
        ArrayList<MetricData> result = new ArrayList<MetricData>();
        this.openCensusMetricStorage.getAllMetricProducer().forEach(producer -> producer.getMetrics().forEach(metric -> result.add(MetricAdapter.convert(resource, metric))));
        return result;
    }
}

