/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BinaryBuffer {
    private final List<Slice> chunks;
    private final int[] offsets;

    public BinaryBuffer(int valueCount) {
        this(new int[valueCount + 1], new ArrayList<Slice>());
    }

    private BinaryBuffer(int[] offsets, List<Slice> chunks) {
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.chunks = Objects.requireNonNull(chunks, "chunks is null");
    }

    public BinaryBuffer withTemporaryOffsets(int offset, int offsetCount) {
        int[] tmpOffsets = new int[offsetCount + 1];
        tmpOffsets[0] = this.offsets[offset];
        return new BinaryBuffer(tmpOffsets, this.chunks);
    }

    public void add(byte[] source, int offset) {
        this.add(Slices.wrappedBuffer((byte[])source), offset);
    }

    public void add(Slice slice, int offset) {
        this.chunks.add(slice);
        this.offsets[offset + 1] = this.offsets[offset] + slice.length();
    }

    public void addChunk(Slice slice) {
        this.chunks.add(slice);
    }

    public Slice asSlice() {
        if (this.chunks.size() == 1) {
            return this.chunks.get(0);
        }
        int totalLength = 0;
        for (Slice chunk : this.chunks) {
            totalLength += chunk.length();
        }
        Slice slice = Slices.allocate((int)totalLength);
        int offset = 0;
        for (Slice chunk : this.chunks) {
            slice.setBytes(offset, chunk);
            offset += chunk.length();
        }
        this.chunks.clear();
        this.chunks.add(slice);
        return slice;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int getValueCount() {
        return this.offsets.length - 1;
    }

    public long getRetainedSize() {
        long chunksSizeInBytes = 0L;
        for (Slice slice : this.chunks) {
            chunksSizeInBytes += slice.getRetainedSize();
        }
        return SizeOf.sizeOf((int[])this.offsets) + chunksSizeInBytes;
    }
}

