/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import java.util.Map;
import java.util.Optional;

public final class TrinoViewUtil {
    private TrinoViewUtil() {
    }

    public static Optional<ConnectorViewDefinition> getView(Optional<String> viewOriginalText, String tableType, Map<String, String> tableParameters, Optional<String> tableOwner) {
        if (!ViewReaderUtil.isTrinoView(tableType, tableParameters)) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)viewOriginalText.isPresent(), (Object)"viewOriginalText must be present");
        ConnectorViewDefinition definition = ViewReaderUtil.PrestoViewReader.decodeViewData(viewOriginalText.get());
        if (tableOwner.isPresent() && !definition.isRunAsInvoker()) {
            definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), definition.getComment(), tableOwner, false, definition.getPath());
        }
        return Optional.of(definition);
    }

    public static Map<String, String> createViewProperties(ConnectorSession session, String trinoVersion, String connectorName) {
        return ImmutableMap.builder().put((Object)"presto_view", (Object)"true").put((Object)"trino_created_by", (Object)connectorName).put((Object)"trino_version", (Object)trinoVersion).put((Object)"trino_query_id", (Object)session.getQueryId()).put((Object)"comment", (Object)"Presto View").buildOrThrow();
    }
}

