/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.projection;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.projection.InvalidProjectionException;
import io.trino.plugin.hive.projection.PartitionProjectionProperties;
import io.trino.plugin.hive.projection.Projection;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class IntegerProjection
implements Projection {
    private final String columnName;
    private final int leftBound;
    private final int rightBound;
    private final int interval;
    private final Optional<Integer> digits;

    public IntegerProjection(String columnName, Type columnType, Map<String, Object> columnProperties) {
        if (!(columnType instanceof VarcharType || columnType instanceof IntegerType || columnType instanceof BigintType)) {
            throw new InvalidProjectionException(columnName, columnType);
        }
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        List range = (List)PartitionProjectionProperties.getProjectionPropertyRequiredValue(columnName, columnProperties, "partition_projection_range", value -> (ImmutableList)((List)value).stream().map(element -> Integer.valueOf((String)element)).collect(ImmutableList.toImmutableList()));
        if (range.size() != 2) {
            throw new InvalidProjectionException(columnName, String.format("Property: '%s' needs to be list of 2 integers", "partition_projection_range"));
        }
        this.leftBound = (Integer)range.get(0);
        this.rightBound = (Integer)range.get(1);
        this.interval = PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_interval", Integer.class::cast).orElse(1);
        this.digits = PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_digits", Integer.class::cast);
    }

    @Override
    public List<String> getProjectedValues(Optional<Domain> partitionValueFilter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int current = this.leftBound; current <= this.rightBound; current += this.interval) {
            int currentValue = current;
            String currentValueFormatted = this.digits.map(digits -> String.format("%0" + digits + "d", currentValue)).orElseGet(() -> Integer.toString(currentValue));
            if (!this.isValueInDomain(partitionValueFilter, current, currentValueFormatted)) continue;
            builder.add((Object)currentValueFormatted);
        }
        return builder.build();
    }

    private boolean isValueInDomain(Optional<Domain> valueDomain, int value, String formattedValue) {
        if (valueDomain.isEmpty() || valueDomain.get().isAll()) {
            return true;
        }
        Domain domain = valueDomain.get();
        Type type = domain.getType();
        if (type instanceof VarcharType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)Slices.utf8Slice((String)formattedValue)));
        }
        if (type instanceof IntegerType || type instanceof BigintType) {
            return domain.contains(Domain.singleValue((Type)type, (Object)value));
        }
        throw new InvalidProjectionException(this.columnName, type);
    }
}

