/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.security.SemiTransactionalSqlStandardAccessControlMetastore;
import io.trino.plugin.hive.security.SqlStandardAccessControl;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadataMetastore;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetastore;
import io.trino.spi.connector.ConnectorAccessControl;

public class SqlStandardSecurityModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ConnectorAccessControl.class).to(SqlStandardAccessControl.class).in(Scopes.SINGLETON);
        binder.bind(AccessControlMetadataFactory.class).to(SqlStandardAccessControlMetadataFactory.class);
        OptionalBinder.newOptionalBinder((Binder)binder, SqlStandardAccessControlMetastore.class).setDefault().to(SemiTransactionalSqlStandardAccessControlMetastore.class).in(Scopes.SINGLETON);
    }

    private static final class SqlStandardAccessControlMetadataFactory
    implements AccessControlMetadataFactory {
        @Override
        public AccessControlMetadata create(SqlStandardAccessControlMetadataMetastore metastore) {
            return new SqlStandardAccessControlMetadata(metastore);
        }
    }
}

