/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.checkpoint;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import io.trino.orc.StreamId;
import io.trino.orc.checkpoint.BooleanStreamCheckpoint;
import io.trino.orc.checkpoint.ByteArrayStreamCheckpoint;
import io.trino.orc.checkpoint.ByteStreamCheckpoint;
import io.trino.orc.checkpoint.DecimalStreamCheckpoint;
import io.trino.orc.checkpoint.DoubleStreamCheckpoint;
import io.trino.orc.checkpoint.FloatStreamCheckpoint;
import io.trino.orc.checkpoint.InputStreamCheckpoint;
import io.trino.orc.checkpoint.InvalidCheckpointException;
import io.trino.orc.checkpoint.LongStreamV1Checkpoint;
import io.trino.orc.checkpoint.LongStreamV2Checkpoint;
import io.trino.orc.checkpoint.StreamCheckpoint;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Checkpoints {
    private Checkpoints() {
    }

    public static Map<StreamId, StreamCheckpoint> getStreamCheckpoints(Set<OrcColumnId> columns, ColumnMetadata<OrcType> columnTypes, boolean compressed, int rowGroupId, ColumnMetadata<ColumnEncoding> columnEncodings, Map<StreamId, Stream> streams, Map<StreamId, List<RowGroupIndex>> columnIndexes) throws InvalidCheckpointException {
        ImmutableSetMultimap.Builder streamKindsBuilder = ImmutableSetMultimap.builder();
        for (Stream stream : streams.values()) {
            streamKindsBuilder.put((Object)stream.getColumnId(), (Object)stream.getStreamKind());
        }
        ImmutableSetMultimap streamKinds = streamKindsBuilder.build();
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        block14: for (Map.Entry<StreamId, List<RowGroupIndex>> entry : columnIndexes.entrySet()) {
            OrcColumnId columnId = entry.getKey().getColumnId();
            if (!columns.contains(columnId)) continue;
            List<Integer> positionsList = entry.getValue().get(rowGroupId).getPositions();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(columnId).getColumnEncodingKind();
            OrcType.OrcTypeKind columnType = columnTypes.get(columnId).getOrcTypeKind();
            Set availableStreams = streamKinds.get((Object)columnId);
            ColumnPositionsList columnPositionsList = new ColumnPositionsList(columnId, columnType, positionsList);
            switch (columnType) {
                case BOOLEAN: {
                    checkpoints.putAll(Checkpoints.getBooleanColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case BYTE: {
                    checkpoints.putAll(Checkpoints.getByteColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    checkpoints.putAll(Checkpoints.getLongColumnCheckpoints(columnId, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case FLOAT: {
                    checkpoints.putAll(Checkpoints.getFloatColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case DOUBLE: {
                    checkpoints.putAll(Checkpoints.getDoubleColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case TIMESTAMP: 
                case TIMESTAMP_INSTANT: {
                    checkpoints.putAll(Checkpoints.getTimestampColumnCheckpoints(columnId, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    checkpoints.putAll(Checkpoints.getSliceColumnCheckpoints(columnId, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case LIST: 
                case MAP: {
                    checkpoints.putAll(Checkpoints.getListOrMapColumnCheckpoints(columnId, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case STRUCT: {
                    checkpoints.putAll(Checkpoints.getStructColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case UNION: {
                    checkpoints.putAll(Checkpoints.getUnionColumnCheckpoints(columnId, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
                case DECIMAL: {
                    checkpoints.putAll(Checkpoints.getDecimalColumnCheckpoints(columnId, columnEncoding, compressed, availableStreams, columnPositionsList));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unsupported column type " + columnType);
        }
        return checkpoints.buildOrThrow();
    }

    public static StreamCheckpoint getDictionaryStreamCheckpoint(StreamId streamId, OrcType.OrcTypeKind columnType, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (columnType) {
                case BINARY: 
                case STRING: 
                case VARCHAR: 
                case CHAR: {
                    return new ByteArrayStreamCheckpoint(InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH || streamId.getStreamKind() == Stream.StreamKind.DATA) {
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
                return new LongStreamV2Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
            if (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
                return new LongStreamV1Checkpoint(0, InputStreamCheckpoint.createInputStreamCheckpoint(0, 0));
            }
        }
        throw new IllegalArgumentException("Unsupported column type " + columnType + " for dictionary stream " + streamId);
    }

    private static Map<StreamId, StreamCheckpoint> getBooleanColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getByteColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new ByteStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getLongColumnCheckpoints(OrcColumnId columnId, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getFloatColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new FloatStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getDoubleColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new DoubleStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getTimestampColumnCheckpoints(OrcColumnId columnId, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getSliceColumnCheckpoints(OrcColumnId columnId, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new ByteArrayStreamCheckpoint(compressed, positionsList));
            }
            if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
                checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else if (encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
                checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
            }
        } else {
            throw new IllegalArgumentException("Unsupported encoding for slice column: " + encoding);
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getListOrMapColumnCheckpoints(OrcColumnId columnId, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.LENGTH)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.LENGTH), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getStructColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getUnionColumnCheckpoints(OrcColumnId columnId, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new ByteStreamCheckpoint(compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static Map<StreamId, StreamCheckpoint> getDecimalColumnCheckpoints(OrcColumnId columnId, ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, Set<Stream.StreamKind> availableStreams, ColumnPositionsList positionsList) {
        ImmutableMap.Builder checkpoints = ImmutableMap.builder();
        if (availableStreams.contains((Object)Stream.StreamKind.PRESENT)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.PRESENT), (Object)new BooleanStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.DATA)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.DATA), (Object)new DecimalStreamCheckpoint(compressed, positionsList));
        }
        if (availableStreams.contains((Object)Stream.StreamKind.SECONDARY)) {
            checkpoints.put((Object)new StreamId(columnId, Stream.StreamKind.SECONDARY), (Object)Checkpoints.createLongStreamCheckpoint(encoding, compressed, positionsList));
        }
        return checkpoints.buildOrThrow();
    }

    private static StreamCheckpoint createLongStreamCheckpoint(ColumnEncoding.ColumnEncodingKind encoding, boolean compressed, ColumnPositionsList positionsList) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongStreamV2Checkpoint(compressed, positionsList);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongStreamV1Checkpoint(compressed, positionsList);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + encoding);
    }

    public static class ColumnPositionsList {
        private final OrcColumnId columnId;
        private final OrcType.OrcTypeKind columnType;
        private final List<Integer> positionsList;
        private int index;

        private ColumnPositionsList(OrcColumnId columnId, OrcType.OrcTypeKind columnType, List<Integer> positionsList) {
            this.columnId = Objects.requireNonNull(columnId, "columnId is null");
            this.columnType = Objects.requireNonNull(columnType, "columnType is null");
            this.positionsList = ImmutableList.copyOf((Collection)Objects.requireNonNull(positionsList, "positionsList is null"));
        }

        public boolean hasNextPosition() {
            return this.index < this.positionsList.size();
        }

        public int nextPosition() {
            if (!this.hasNextPosition()) {
                throw new InvalidCheckpointException("Not enough positions for column %s:%s checkpoints", new Object[]{this.columnId, this.columnType});
            }
            return this.positionsList.get(this.index++);
        }
    }
}

