/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputStream;
import java.io.IOException;
import java.util.Objects;

class MemoryInputStream
extends TrinoInputStream {
    private final Location location;
    private final SliceInput input;
    private final int length;
    private boolean closed;

    public MemoryInputStream(Location location, Slice data) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.input = Objects.requireNonNull(data, "data is null").getInput();
        this.length = data.length();
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.input.available();
    }

    @Override
    public long getPosition() {
        return this.input.position();
    }

    @Override
    public void seek(long position) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (position > (long)this.length) {
            throw new IOException("Cannot seek to %s. File size is %s: %s".formatted(position, this.length, this.location));
        }
        this.input.setPosition(position);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.input.read();
    }

    @Override
    public int read(byte[] destination, int destinationIndex, int length) throws IOException {
        this.ensureOpen();
        return this.input.read(destination, destinationIndex, length);
    }

    @Override
    public long skip(long length) throws IOException {
        this.ensureOpen();
        return this.input.skip(length);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
    }
}

