/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;

public class DeltaLakeInsertTableHandle
implements ConnectorInsertTableHandle {
    private final SchemaTableName tableName;
    private final String location;
    private final MetadataEntry metadataEntry;
    private final ProtocolEntry protocolEntry;
    private final List<DeltaLakeColumnHandle> inputColumns;
    private final long readVersion;
    private final boolean retriesEnabled;

    @JsonCreator
    public DeltaLakeInsertTableHandle(@JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="location") String location, @JsonProperty(value="metadataEntry") MetadataEntry metadataEntry, @JsonProperty(value="protocolEntry") ProtocolEntry protocolEntry, @JsonProperty(value="inputColumns") List<DeltaLakeColumnHandle> inputColumns, @JsonProperty(value="readVersion") long readVersion, @JsonProperty(value="retriesEnabled") boolean retriesEnabled) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.metadataEntry = Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        this.protocolEntry = Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        this.inputColumns = ImmutableList.copyOf(inputColumns);
        this.location = Objects.requireNonNull(location, "location is null");
        this.readVersion = readVersion;
        this.retriesEnabled = retriesEnabled;
    }

    @JsonProperty
    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public MetadataEntry getMetadataEntry() {
        return this.metadataEntry;
    }

    @JsonProperty
    public ProtocolEntry getProtocolEntry() {
        return this.protocolEntry;
    }

    @JsonProperty
    public List<DeltaLakeColumnHandle> getInputColumns() {
        return this.inputColumns;
    }

    @JsonProperty
    public long getReadVersion() {
        return this.readVersion;
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }

    public String toString() {
        return String.valueOf(this.tableName) + "[" + this.location + "]";
    }
}

