/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.AllowDeltaLakeManagedTableRename;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeAccessControlMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeRedirectionsProvider;
import io.trino.plugin.deltalake.metastore.HiveMetastoreBackedDeltaLakeMetastore;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.FileBasedTableStatisticsProvider;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.spi.NodeManager;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeMetadataFactory {
    private final HiveMetastoreFactory hiveMetastoreFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TransactionLogAccess transactionLogAccess;
    private final TypeManager typeManager;
    private final DeltaLakeAccessControlMetadataFactory accessControlMetadataFactory;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final TransactionLogWriterFactory transactionLogWriterFactory;
    private final NodeManager nodeManager;
    private final CheckpointWriterManager checkpointWriterManager;
    private final DeltaLakeRedirectionsProvider deltaLakeRedirectionsProvider;
    private final CachingExtendedStatisticsAccess statisticsAccess;
    private final int domainCompactionThreshold;
    private final boolean unsafeWritesEnabled;
    private final long checkpointWritingInterval;
    private final long perTransactionMetastoreCacheMaximumSize;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean useUniqueTableLocation;
    private final boolean allowManagedTableRename;
    private final String trinoVersion;

    @Inject
    public DeltaLakeMetadataFactory(HiveMetastoreFactory hiveMetastoreFactory, TrinoFileSystemFactory fileSystemFactory, TransactionLogAccess transactionLogAccess, TypeManager typeManager, DeltaLakeAccessControlMetadataFactory accessControlMetadataFactory, DeltaLakeConfig deltaLakeConfig, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, TransactionLogWriterFactory transactionLogWriterFactory, NodeManager nodeManager, CheckpointWriterManager checkpointWriterManager, DeltaLakeRedirectionsProvider deltaLakeRedirectionsProvider, CachingExtendedStatisticsAccess statisticsAccess, @AllowDeltaLakeManagedTableRename boolean allowManagedTableRename, NodeVersion nodeVersion) {
        this.hiveMetastoreFactory = Objects.requireNonNull(hiveMetastoreFactory, "hiveMetastore is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.accessControlMetadataFactory = Objects.requireNonNull(accessControlMetadataFactory, "accessControlMetadataFactory is null");
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.transactionLogWriterFactory = Objects.requireNonNull(transactionLogWriterFactory, "transactionLogWriterFactory is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.checkpointWriterManager = Objects.requireNonNull(checkpointWriterManager, "checkpointWriterManager is null");
        this.deltaLakeRedirectionsProvider = Objects.requireNonNull(deltaLakeRedirectionsProvider, "deltaLakeRedirectionsProvider is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.unsafeWritesEnabled = deltaLakeConfig.getUnsafeWritesEnabled();
        this.checkpointWritingInterval = deltaLakeConfig.getDefaultCheckpointWritingInterval();
        this.perTransactionMetastoreCacheMaximumSize = deltaLakeConfig.getPerTransactionMetastoreCacheMaximumSize();
        this.deleteSchemaLocationsFallback = deltaLakeConfig.isDeleteSchemaLocationsFallback();
        this.useUniqueTableLocation = deltaLakeConfig.isUniqueTableLocation();
        this.allowManagedTableRename = allowManagedTableRename;
        this.trinoVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
    }

    public DeltaLakeMetadata create(ConnectorIdentity identity) {
        CachingHiveMetastore cachingHiveMetastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)this.hiveMetastoreFactory.createMetastore(Optional.of(identity)), (long)this.perTransactionMetastoreCacheMaximumSize);
        AccessControlMetadata accessControlMetadata = this.accessControlMetadataFactory.create((HiveMetastore)cachingHiveMetastore);
        HiveMetastoreBackedDeltaLakeMetastore deltaLakeMetastore = new HiveMetastoreBackedDeltaLakeMetastore((HiveMetastore)cachingHiveMetastore);
        FileBasedTableStatisticsProvider tableStatisticsProvider = new FileBasedTableStatisticsProvider(this.typeManager, this.transactionLogAccess, this.statisticsAccess);
        TrinoViewHiveMetastore trinoViewHiveMetastore = new TrinoViewHiveMetastore((HiveMetastore)cachingHiveMetastore, accessControlMetadata.isUsingSystemSecurity(), this.trinoVersion, "Trino Delta Lake connector");
        return new DeltaLakeMetadata(deltaLakeMetastore, this.transactionLogAccess, tableStatisticsProvider, this.fileSystemFactory, this.typeManager, accessControlMetadata, trinoViewHiveMetastore, this.domainCompactionThreshold, this.unsafeWritesEnabled, this.dataFileInfoCodec, this.mergeResultJsonCodec, this.transactionLogWriterFactory, this.nodeManager, this.checkpointWriterManager, this.checkpointWritingInterval, this.deleteSchemaLocationsFallback, this.deltaLakeRedirectionsProvider, this.statisticsAccess, this.useUniqueTableLocation, this.allowManagedTableRename);
    }
}

