/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.util.Modules;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.deltalake.DeltaLakeAccessControlMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeSecurityConfig;
import io.trino.plugin.hive.security.AllowAllSecurityModule;

public class DeltaLakeSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(switch (((DeltaLakeSecurityConfig)this.buildConfigObject(DeltaLakeSecurityConfig.class)).getSecuritySystem().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ConfigurationAwareModule.combine((Module[])new Module[]{new AllowAllSecurityModule(), new StaticAccessControlMetadataModule()});
            case 1 -> ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()});
            case 2 -> ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule()});
            case 3 -> Modules.EMPTY_MODULE;
        });
    }

    public static enum DeltaLakeSecurity {
        ALLOW_ALL,
        READ_ONLY,
        FILE,
        SYSTEM;

    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            OptionalBinder.newOptionalBinder((Binder)binder, DeltaLakeAccessControlMetadataFactory.class).setBinding().toInstance((Object)DeltaLakeAccessControlMetadataFactory.DEFAULT);
        }
    }
}

