/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record DeltaLakeTable(List<DeltaLakeColumn> columns, List<String> constraints) {
    public DeltaLakeTable {
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(constraints, "constraints is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns must not be empty");
        columns = ImmutableList.copyOf(columns);
        constraints = ImmutableList.copyOf(constraints);
    }

    public DeltaLakeColumn findColumn(String name) {
        Objects.requireNonNull(name, "name is null");
        return (DeltaLakeColumn)this.columns.stream().filter(column -> column.name.equals(name)).collect(MoreCollectors.onlyElement());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        return new Builder(metadataEntry, protocolEntry);
    }

    public record DeltaLakeColumn(String name, Object type, boolean nullable, @Nullable String comment, @Nullable Map<String, Object> metadata, Optional<String> generationExpression) {
        public DeltaLakeColumn {
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            Objects.requireNonNull(type, "type is null");
            Objects.requireNonNull(generationExpression, "generationExpression is null");
        }
    }

    public static class Builder {
        private final List<DeltaLakeColumn> columns = new ArrayList<DeltaLakeColumn>();
        private final List<String> constraints = new ArrayList<String>();

        public Builder() {
        }

        public Builder(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
            Objects.requireNonNull(metadataEntry, "metadataEntry is null");
            Map<String, Object> columnTypes = DeltaLakeSchemaSupport.getColumnTypes(metadataEntry);
            Map<String, Boolean> columnsNullability = DeltaLakeSchemaSupport.getColumnsNullability(metadataEntry);
            Map<String, String> columnComments = DeltaLakeSchemaSupport.getColumnComments(metadataEntry);
            Map<String, Map<String, Object>> columnsMetadata = DeltaLakeSchemaSupport.getColumnsMetadata(metadataEntry);
            Map<String, String> columnGenerations = DeltaLakeSchemaSupport.getGeneratedColumnExpressions(metadataEntry);
            for (String columnName : DeltaLakeSchemaSupport.getExactColumnNames(metadataEntry)) {
                this.columns.add(new DeltaLakeColumn(columnName, columnTypes.get(columnName), columnsNullability.getOrDefault(columnName, true), columnComments.get(columnName), columnsMetadata.get(columnName), Optional.ofNullable(columnGenerations.get(columnName))));
            }
            this.constraints.addAll((Collection<String>)ImmutableList.builder().addAll(DeltaLakeSchemaSupport.getCheckConstraints(metadataEntry, protocolEntry).values()).addAll(DeltaLakeSchemaSupport.getColumnInvariants(metadataEntry, protocolEntry).values()).build());
        }

        public Builder addColumn(String name, Object type, boolean nullable, @Nullable String comment, @Nullable Map<String, Object> metadata) {
            this.columns.add(new DeltaLakeColumn(name, type, nullable, comment, metadata, Optional.empty()));
            return this;
        }

        public Builder renameColumn(String source, String target) {
            Preconditions.checkArgument((boolean)this.columns.stream().noneMatch(column -> column.name.equalsIgnoreCase(target)), (String)"Column already exists: %s", (Object)target);
            DeltaLakeColumn column2 = this.findColumn(source);
            int index = this.columns.indexOf(column2);
            Verify.verify((index >= 0 ? 1 : 0) != 0, (String)"Unexpected column index", (Object[])new Object[0]);
            DeltaLakeColumn newColumn = new DeltaLakeColumn(target, column2.type, column2.nullable, column2.comment, column2.metadata, column2.generationExpression);
            this.columns.set(index, newColumn);
            return this;
        }

        public Builder removeColumn(String name) {
            DeltaLakeColumn column = this.findColumn(name);
            boolean removed = this.columns.remove(column);
            Preconditions.checkState((boolean)removed, (String)"Failed to remove '%s' from %s", (Object)name, this.columns);
            return this;
        }

        public Builder setColumnComment(String name, @Nullable String comment) {
            DeltaLakeColumn oldColumn = this.findColumn(name);
            DeltaLakeColumn newColumn = new DeltaLakeColumn(oldColumn.name, oldColumn.type, oldColumn.nullable, comment, oldColumn.metadata, oldColumn.generationExpression);
            this.columns.set(this.columns.indexOf(oldColumn), newColumn);
            return this;
        }

        public Builder dropNotNullConstraint(String name) {
            DeltaLakeColumn oldColumn = this.findColumn(name);
            Verify.verify((!oldColumn.nullable ? 1 : 0) != 0, (String)"Column '%s' is already nullable", (Object)name);
            DeltaLakeColumn newColumn = new DeltaLakeColumn(oldColumn.name, oldColumn.type, true, oldColumn.comment, oldColumn.metadata, oldColumn.generationExpression);
            this.columns.set(this.columns.indexOf(oldColumn), newColumn);
            return this;
        }

        private DeltaLakeColumn findColumn(String name) {
            Objects.requireNonNull(name, "name is null");
            return (DeltaLakeColumn)this.columns.stream().filter(column -> column.name.equals(name)).collect(MoreCollectors.onlyElement());
        }

        public DeltaLakeTable build() {
            return new DeltaLakeTable(this.columns, this.constraints);
        }
    }
}

