/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.amazonaws.services.glue.model.Table;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.deltalake.metastore.glue.DeltaLakeGlueMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.plugin.hive.util.HiveUtil;
import java.util.Map;
import java.util.function.Predicate;

public class DeltaLakeGlueMetastoreTableFilterProvider
implements Provider<Predicate<Table>> {
    private final boolean hideNonDeltaLakeTables;

    @Inject
    public DeltaLakeGlueMetastoreTableFilterProvider(DeltaLakeGlueMetastoreConfig config) {
        this.hideNonDeltaLakeTables = config.isHideNonDeltaLakeTables();
    }

    public Predicate<Table> get() {
        if (this.hideNonDeltaLakeTables) {
            return table -> HiveUtil.isDeltaLakeTable((Map)GlueToTrinoConverter.getTableParameters((Table)table));
        }
        return table -> true;
    }
}

