/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ProtocolEntry {
    private static final int MIN_VERSION_SUPPORTS_READER_FEATURES = 3;
    private static final int MIN_VERSION_SUPPORTS_WRITER_FEATURES = 7;
    private final int minReaderVersion;
    private final int minWriterVersion;
    private final Optional<Set<String>> readerFeatures;
    private final Optional<Set<String>> writerFeatures;

    @JsonCreator
    public ProtocolEntry(@JsonProperty(value="minReaderVersion") int minReaderVersion, @JsonProperty(value="minWriterVersion") int minWriterVersion, @JsonProperty(value="readerFeatures") Optional<Set<String>> readerFeatures, @JsonProperty(value="writerFeatures") Optional<Set<String>> writerFeatures) {
        this.minReaderVersion = minReaderVersion;
        this.minWriterVersion = minWriterVersion;
        if (minReaderVersion < 3 && readerFeatures.isPresent()) {
            throw new IllegalArgumentException("readerFeatures must not exist when minReaderVersion is less than 3");
        }
        if (minWriterVersion < 7 && writerFeatures.isPresent()) {
            throw new IllegalArgumentException("writerFeatures must not exist when minWriterVersion is less than 7");
        }
        this.readerFeatures = readerFeatures;
        this.writerFeatures = writerFeatures;
    }

    @JsonProperty
    public int getMinReaderVersion() {
        return this.minReaderVersion;
    }

    @JsonProperty
    public int getMinWriterVersion() {
        return this.minWriterVersion;
    }

    @JsonProperty
    public Optional<Set<String>> getReaderFeatures() {
        return this.readerFeatures;
    }

    @JsonProperty
    public Optional<Set<String>> getWriterFeatures() {
        return this.writerFeatures;
    }

    public boolean supportsReaderFeatures() {
        return this.minReaderVersion >= 3;
    }

    public boolean readerFeaturesContains(String featureName) {
        return this.readerFeatures.map(features -> features.contains(featureName)).orElse(false);
    }

    public boolean supportsWriterFeatures() {
        return this.minWriterVersion >= 7;
    }

    public boolean writerFeaturesContains(String featureName) {
        return this.writerFeatures.map(features -> features.contains(featureName)).orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolEntry that = (ProtocolEntry)o;
        return this.minReaderVersion == that.minReaderVersion && this.minWriterVersion == that.minWriterVersion && this.readerFeatures.equals(that.readerFeatures) && this.writerFeatures.equals(that.writerFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.minReaderVersion, this.minWriterVersion, this.readerFeatures, this.writerFeatures);
    }

    public String toString() {
        return String.format("ProtocolEntry{minReaderVersion=%d, minWriterVersion=%d, readerFeatures=%s, writerFeatures=%s}", this.minReaderVersion, this.minWriterVersion, this.readerFeatures, this.writerFeatures);
    }
}

