/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import com.linkedin.coral.trino.rel2trino.RelToTrinoConverter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoKeywordsConverter;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.hive.CoralTableRedirectionResolver;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.LegacyHiveViewReader;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.CoralSemiTransactionalHiveMSCAdapter;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.TypeManager;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;

public final class ViewReaderUtil {
    public static final String ICEBERG_MATERIALIZED_VIEW_COMMENT = "Presto Materialized View";
    public static final String PRESTO_VIEW_FLAG = "presto_view";
    static final String VIEW_PREFIX = "/* Presto View: ";
    static final String VIEW_SUFFIX = " */";
    private static final JsonCodec<ConnectorViewDefinition> VIEW_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(ConnectorViewDefinition.class);

    private ViewReaderUtil() {
    }

    public static ViewReader createViewReader(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, TypeManager typeManager, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> tableRedirectionResolver, MetadataProvider metadataProvider, boolean runHiveViewRunAsInvoker, HiveTimestampPrecision hiveViewsTimestampPrecision) {
        if (ViewReaderUtil.isTrinoView(table)) {
            return new PrestoViewReader();
        }
        if (HiveSessionProperties.isHiveViewsLegacyTranslation(session)) {
            return new LegacyHiveViewReader(runHiveViewRunAsInvoker);
        }
        return new HiveViewReader(new CoralSemiTransactionalHiveMSCAdapter(metastore, ViewReaderUtil.coralTableRedirectionResolver(session, tableRedirectionResolver, metadataProvider)), typeManager, runHiveViewRunAsInvoker, hiveViewsTimestampPrecision);
    }

    private static CoralTableRedirectionResolver coralTableRedirectionResolver(ConnectorSession session, BiFunction<ConnectorSession, SchemaTableName, Optional<CatalogSchemaTableName>> tableRedirectionResolver, MetadataProvider metadataProvider) {
        return schemaTableName -> ((Optional)tableRedirectionResolver.apply(session, schemaTableName)).map(target -> {
            ConnectorTableSchema tableSchema = (ConnectorTableSchema)metadataProvider.getRelationMetadata(session, target).orElseThrow(() -> new TableNotFoundException(target.getSchemaTableName(), String.format("%s is redirected to %s, but that relation cannot be found", schemaTableName, target)));
            List columns = (List)tableSchema.getColumns().stream().filter(columnSchema -> !columnSchema.isHidden()).map(columnSchema -> new Column(columnSchema.getName(), HiveType.toHiveType(columnSchema.getType()), Optional.empty(), Map.of())).collect(ImmutableList.toImmutableList());
            Table table = Table.builder().setDatabaseName(schemaTableName.getSchemaName()).setTableName(schemaTableName.getTableName()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(columns).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat(HiveStorageFormat.TEXTFILE))).setOwner(Optional.empty()).build();
            return ThriftMetastoreUtil.toMetastoreApiTable(table);
        });
    }

    public static boolean isSomeKindOfAView(Table table) {
        return table.getTableType().equals(TableType.VIRTUAL_VIEW.name());
    }

    public static boolean isHiveView(Table table) {
        return table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !table.getParameters().containsKey(PRESTO_VIEW_FLAG);
    }

    public static boolean isTrinoView(Table table) {
        return ViewReaderUtil.isTrinoView(table.getTableType(), table.getParameters());
    }

    public static boolean isTrinoView(String tableType, Map<String, String> tableParameters) {
        return tableType.equals(TableType.VIRTUAL_VIEW.name()) && "true".equals(tableParameters.get(PRESTO_VIEW_FLAG)) && "Presto View".equalsIgnoreCase(tableParameters.get("comment"));
    }

    public static boolean isTrinoMaterializedView(Table table) {
        return ViewReaderUtil.isTrinoMaterializedView(table.getTableType(), table.getParameters());
    }

    public static boolean isTrinoMaterializedView(String tableType, Map<String, String> tableParameters) {
        return tableType.equals(TableType.VIRTUAL_VIEW.name()) && "true".equals(tableParameters.get(PRESTO_VIEW_FLAG)) && ICEBERG_MATERIALIZED_VIEW_COMMENT.equalsIgnoreCase(tableParameters.get("comment"));
    }

    public static String encodeViewData(ConnectorViewDefinition definition) {
        byte[] bytes = VIEW_CODEC.toJsonBytes((Object)definition);
        String data = Base64.getEncoder().encodeToString(bytes);
        return VIEW_PREFIX + data + VIEW_SUFFIX;
    }

    public static class PrestoViewReader
    implements ViewReader {
        @Override
        public ConnectorViewDefinition decodeViewData(String viewData, Table table, CatalogName catalogName) {
            return PrestoViewReader.decodeViewData(viewData);
        }

        public static ConnectorViewDefinition decodeViewData(String viewData) {
            HiveUtil.checkCondition(viewData.startsWith(ViewReaderUtil.VIEW_PREFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing prefix: %s", viewData);
            HiveUtil.checkCondition(viewData.endsWith(ViewReaderUtil.VIEW_SUFFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing suffix: %s", viewData);
            viewData = viewData.substring(ViewReaderUtil.VIEW_PREFIX.length());
            viewData = viewData.substring(0, viewData.length() - ViewReaderUtil.VIEW_SUFFIX.length());
            byte[] bytes = Base64.getDecoder().decode(viewData);
            return (ConnectorViewDefinition)VIEW_CODEC.fromJson(bytes);
        }
    }

    public static class HiveViewReader
    implements ViewReader {
        private final HiveMetastoreClient metastoreClient;
        private final TypeManager typeManager;
        private final boolean hiveViewsRunAsInvoker;
        private final HiveTimestampPrecision hiveViewsTimestampPrecision;

        public HiveViewReader(HiveMetastoreClient hiveMetastoreClient, TypeManager typeManager, boolean hiveViewsRunAsInvoker, HiveTimestampPrecision hiveViewsTimestampPrecision) {
            this.metastoreClient = Objects.requireNonNull(hiveMetastoreClient, "hiveMetastoreClient is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.hiveViewsRunAsInvoker = hiveViewsRunAsInvoker;
            this.hiveViewsTimestampPrecision = Objects.requireNonNull(hiveViewsTimestampPrecision, "hiveViewsTimestampPrecision is null");
        }

        @Override
        public ConnectorViewDefinition decodeViewData(String viewSql, Table table, CatalogName catalogName) {
            try {
                HiveToRelConverter hiveToRelConverter = new HiveToRelConverter(this.metastoreClient);
                RelNode rel = hiveToRelConverter.convertView(table.getDatabaseName(), table.getTableName());
                RelToTrinoConverter relToTrino = new RelToTrinoConverter(this.metastoreClient);
                String trinoSql = relToTrino.convert(rel);
                RelDataType rowType = rel.getRowType();
                List columns = (List)rowType.getFieldList().stream().map(field -> new ConnectorViewDefinition.ViewColumn(field.getName(), this.typeManager.fromSqlType(HiveViewReader.getTypeString(field.getType(), this.hiveViewsTimestampPrecision)).getTypeId(), Optional.empty())).collect(ImmutableList.toImmutableList());
                return new ConnectorViewDefinition(trinoSql, Optional.of(catalogName.toString()), Optional.of(table.getDatabaseName()), columns, Optional.ofNullable(table.getParameters().get("comment")), Optional.empty(), this.hiveViewsRunAsInvoker, (List)ImmutableList.of());
            }
            catch (Throwable e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR, String.format("Failed to translate Hive view '%s': %s", table.getSchemaTableName(), e.getMessage()), e);
            }
        }

        private static String getTypeString(RelDataType type, HiveTimestampPrecision timestampPrecision) {
            switch (type.getSqlTypeName()) {
                case ROW: {
                    Verify.verify((boolean)type.isStruct(), (String)"expected ROW type to be a struct: %s", (Object)type);
                    return type.getFieldList().stream().map(field -> TrinoKeywordsConverter.quoteWordIfNotQuoted((String)field.getName().toLowerCase(Locale.ENGLISH)) + " " + HiveViewReader.getTypeString(field.getType(), timestampPrecision)).collect(Collectors.joining(",", "row(", ")"));
                }
                case CHAR: {
                    return "char(" + type.getPrecision() + ")";
                }
                case FLOAT: {
                    return "real";
                }
                case BINARY: 
                case VARBINARY: {
                    return "varbinary";
                }
                case MAP: {
                    RelDataType keyType = type.getKeyType();
                    RelDataType valueType = type.getValueType();
                    return "map(" + HiveViewReader.getTypeString(keyType, timestampPrecision) + "," + HiveViewReader.getTypeString(valueType, timestampPrecision) + ")";
                }
                case ARRAY: {
                    return "array(" + HiveViewReader.getTypeString(type.getComponentType(), timestampPrecision) + ")";
                }
                case DECIMAL: {
                    return "decimal(" + type.getPrecision() + "," + type.getScale() + ")";
                }
                case TIMESTAMP: {
                    return "timestamp(" + timestampPrecision.getPrecision() + ")";
                }
            }
            return type.getSqlTypeName().toString();
        }
    }

    public static interface ViewReader {
        public ConnectorViewDefinition decodeViewData(String var1, Table var2, CatalogName var3);
    }
}

