/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.VarcharType;

public class DoubleToVarcharCoercer
extends TypeCoercer<DoubleType, VarcharType> {
    private final boolean isOrcFile;

    public DoubleToVarcharCoercer(VarcharType toType, boolean isOrcFile) {
        super(DoubleType.DOUBLE, toType);
        this.isOrcFile = isOrcFile;
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        double doubleValue = DoubleType.DOUBLE.getDouble(block, position);
        if (Double.isNaN(doubleValue) && this.isOrcFile) {
            blockBuilder.appendNull();
            return;
        }
        Slice converted = Slices.utf8Slice((String)Double.toString(doubleValue));
        if (!((VarcharType)this.toType).isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > ((VarcharType)this.toType).getBoundedLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", doubleValue, this.toType));
        }
        ((VarcharType)this.toType).writeSlice(blockBuilder, converted);
    }
}

