/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.hive.metastore.api.StorageDescriptor;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.SerDeInfo;
import io.trino.hive.thrift.metastore.Table;
import io.trino.plugin.hive.CoralTableRedirectionResolver;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CoralSemiTransactionalHiveMSCAdapter
implements HiveMetastoreClient {
    private final SemiTransactionalHiveMetastore delegate;
    private final CoralTableRedirectionResolver tableRedirection;

    public CoralSemiTransactionalHiveMSCAdapter(SemiTransactionalHiveMetastore coralHiveMetastoreClient, CoralTableRedirectionResolver tableRedirection) {
        this.delegate = Objects.requireNonNull(coralHiveMetastoreClient, "coralHiveMetastoreClient is null");
        this.tableRedirection = Objects.requireNonNull(tableRedirection, "tableRedirection is null");
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    public com.linkedin.coral.hive.metastore.api.Database getDatabase(String dbName) {
        return this.delegate.getDatabase(dbName).map(database -> CoralSemiTransactionalHiveMSCAdapter.toHiveDatabase(ThriftMetastoreUtil.toMetastoreApiDatabase(database))).orElse(null);
    }

    public List<String> getAllTables(String dbName) {
        return this.delegate.getTables(dbName).stream().map(tableInfo -> tableInfo.tableName().getTableName()).toList();
    }

    public com.linkedin.coral.hive.metastore.api.Table getTable(String dbName, String tableName) {
        Optional<Table> redirected;
        if (!dbName.isEmpty() && !tableName.isEmpty() && (redirected = this.tableRedirection.redirect(new SchemaTableName(dbName, tableName))).isPresent()) {
            return CoralSemiTransactionalHiveMSCAdapter.toHiveTable(redirected.get());
        }
        return this.delegate.getTable(dbName, tableName).map(value -> CoralSemiTransactionalHiveMSCAdapter.toHiveTable(ThriftMetastoreUtil.toMetastoreApiTable(value, PrincipalPrivileges.NO_PRIVILEGES))).orElse(null);
    }

    private static com.linkedin.coral.hive.metastore.api.Database toHiveDatabase(Database database) {
        com.linkedin.coral.hive.metastore.api.Database result = new com.linkedin.coral.hive.metastore.api.Database();
        result.setName(database.getName());
        result.setDescription(database.getDescription());
        result.setLocationUri(database.getLocationUri());
        result.setParameters(database.getParameters());
        return result;
    }

    private static com.linkedin.coral.hive.metastore.api.Table toHiveTable(Table table) {
        com.linkedin.coral.hive.metastore.api.Table result = new com.linkedin.coral.hive.metastore.api.Table();
        result.setDbName(table.getDbName());
        result.setTableName(table.getTableName());
        result.setTableType(table.getTableType());
        result.setViewOriginalText(table.getViewOriginalText());
        result.setViewExpandedText(table.getViewExpandedText());
        result.setPartitionKeys(table.getPartitionKeys().stream().map(CoralSemiTransactionalHiveMSCAdapter::toHiveFieldSchema).toList());
        result.setParameters(table.getParameters());
        result.setSd(CoralSemiTransactionalHiveMSCAdapter.toHiveStorageDescriptor(table.getSd()));
        return result;
    }

    private static StorageDescriptor toHiveStorageDescriptor(io.trino.hive.thrift.metastore.StorageDescriptor storage) {
        StorageDescriptor result = new StorageDescriptor();
        result.setCols(storage.getCols().stream().map(CoralSemiTransactionalHiveMSCAdapter::toHiveFieldSchema).toList());
        result.setBucketCols(storage.getBucketCols());
        result.setNumBuckets(storage.getNumBuckets());
        result.setInputFormat(storage.getInputFormat());
        result.setOutputFormat(storage.getInputFormat());
        result.setSerdeInfo(CoralSemiTransactionalHiveMSCAdapter.toHiveSerdeInfo(storage.getSerdeInfo()));
        result.setLocation(storage.getLocation());
        result.setParameters(storage.getParameters());
        return result;
    }

    private static com.linkedin.coral.hive.metastore.api.SerDeInfo toHiveSerdeInfo(SerDeInfo info) {
        com.linkedin.coral.hive.metastore.api.SerDeInfo result = new com.linkedin.coral.hive.metastore.api.SerDeInfo();
        result.setName(info.getName());
        result.setDescription(info.getDescription());
        result.setSerializationLib(info.getSerializationLib());
        result.setSerializerClass(info.getSerializerClass());
        result.setDeserializerClass(info.getDeserializerClass());
        result.setParameters(info.getParameters());
        return result;
    }

    private static com.linkedin.coral.hive.metastore.api.FieldSchema toHiveFieldSchema(FieldSchema field) {
        com.linkedin.coral.hive.metastore.api.FieldSchema result = new com.linkedin.coral.hive.metastore.api.FieldSchema();
        result.setName(field.getName());
        result.setType(field.getType());
        result.setComment(field.getComment());
        return result;
    }
}

