/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.type.ListTypeInfo;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

final class HiveBucketingV1 {
    private HiveBucketingV1() {
    }

    static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        Preconditions.checkArgument((types.size() <= page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < types.size(); ++i) {
            int fieldHash = HiveBucketingV1.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int getBucketHashCode(List<TypeInfo> types, Object[] values) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketingV1.hash(types.get(i), values[i]);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type trinoType = Objects.requireNonNull(HiveTypeTranslator.fromPrimitiveType(typeInfo));
                if (trinoType.equals((Object)BooleanType.BOOLEAN)) {
                    return BooleanType.BOOLEAN.getBoolean(block, position) ? 1 : 0;
                }
                if (trinoType.equals((Object)TinyintType.TINYINT)) {
                    return TinyintType.TINYINT.getByte(block, position);
                }
                if (trinoType.equals((Object)SmallintType.SMALLINT)) {
                    return SmallintType.SMALLINT.getShort(block, position);
                }
                if (trinoType.equals((Object)IntegerType.INTEGER)) {
                    return IntegerType.INTEGER.getInt(block, position);
                }
                if (trinoType.equals((Object)BigintType.BIGINT)) {
                    long bigintValue = BigintType.BIGINT.getLong(block, position);
                    return (int)(bigintValue >>> 32 ^ bigintValue);
                }
                if (trinoType.equals((Object)RealType.REAL)) {
                    return Float.floatToIntBits(RealType.REAL.getFloat(block, position));
                }
                if (trinoType.equals((Object)DoubleType.DOUBLE)) {
                    long doubleValue = Double.doubleToLongBits(DoubleType.DOUBLE.getDouble(block, position));
                    return (int)(doubleValue >>> 32 ^ doubleValue);
                }
                if (trinoType instanceof VarcharType) {
                    VarcharType varcharType = (VarcharType)trinoType;
                    int initial = switch (primitiveCategory) {
                        case PrimitiveCategory.STRING -> 0;
                        case PrimitiveCategory.VARCHAR -> 1;
                        default -> throw new VerifyException("Unexpected category: " + String.valueOf((Object)primitiveCategory));
                    };
                    return HiveBucketingV1.hashBytes(initial, varcharType.getSlice(block, position));
                }
                if (trinoType.equals((Object)DateType.DATE)) {
                    return DateType.DATE.getInt(block, position);
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + String.valueOf((Object)primitiveCategory));
            }
            case LIST: {
                Block array = ((ArrayBlock)block.getUnderlyingValueBlock()).getArray(block.getUnderlyingValuePosition(position));
                return HiveBucketingV1.hashOfList((ListTypeInfo)type, array);
            }
            case MAP: {
                SqlMap map = ((MapBlock)block.getUnderlyingValueBlock()).getMap(block.getUnderlyingValuePosition(position));
                return HiveBucketingV1.hashOfMap((MapTypeInfo)type, map);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + String.valueOf((Object)type.getCategory()));
    }

    private static int hash(TypeInfo type, Object value) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)((Long)value));
                    }
                    case INT: {
                        return Math.toIntExact((Long)value);
                    }
                    case LONG: {
                        long bigintValue = (Long)value;
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return Float.floatToIntBits(Float.intBitsToFloat(Math.toIntExact((Long)value)));
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits((Double)value);
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketingV1.hashBytes(0, (Slice)value);
                    }
                    case VARCHAR: {
                        return HiveBucketingV1.hashBytes(1, (Slice)value);
                    }
                    case DATE: {
                        return Math.toIntExact((Long)value);
                    }
                    case TIMESTAMP: {
                        break;
                    }
                    case DECIMAL: 
                    case CHAR: 
                    case BINARY: 
                    case TIMESTAMPLOCALTZ: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_DAY_TIME: {
                        break;
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + String.valueOf((Object)primitiveCategory));
            }
            case LIST: {
                return HiveBucketingV1.hashOfList((ListTypeInfo)type, (Block)value);
            }
            case MAP: {
                return HiveBucketingV1.hashOfMap((MapTypeInfo)type, (SqlMap)value);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + String.valueOf((Object)type.getCategory()));
    }

    private static int hashOfMap(MapTypeInfo type, SqlMap sqlMap) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        int result = 0;
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            result += HiveBucketingV1.hash(keyTypeInfo, rawKeyBlock, rawOffset + i) ^ HiveBucketingV1.hash(valueTypeInfo, rawValueBlock, rawOffset + i);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketingV1.hash(elementTypeInfo, singleListBlock, i);
        }
        return result;
    }

    private static int hashBytes(int initialValue, Slice bytes) {
        int result = initialValue;
        for (int i = 0; i < bytes.length(); ++i) {
            result = result * 31 + bytes.getByte(i);
        }
        return result;
    }
}

