/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTypes;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.util.DeltaLakeWriteUtils;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.parquet.format.CompressionCodec;

public abstract class AbstractDeltaLakePageSink
implements ConnectorPageSink {
    private static final Logger LOG = Logger.get(AbstractDeltaLakePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final TypeOperators typeOperators;
    private final List<DeltaLakeColumnHandle> dataColumnHandles;
    private final int[] dataColumnInputIndex;
    private final List<String> dataColumnNames;
    private final List<Type> dataColumnTypes;
    private final int[] partitionColumnsInputIndex;
    private final List<String> originalPartitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final PageIndexer pageIndexer;
    private final TrinoFileSystem fileSystem;
    private final int maxOpenWriters;
    protected final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final List<DeltaLakeWriter> writers = new ArrayList<DeltaLakeWriter>();
    private final Location tableLocation;
    protected final Location outputPathDirectory;
    private final ConnectorSession session;
    private final DeltaLakeWriterStats stats;
    private final String trinoVersion;
    private final long targetMaxFileSize;
    private final long idleWriterMinFileSize;
    private long writtenBytes;
    private long memoryUsage;
    private final List<Closeable> closedWriterRollbackActions = new ArrayList<Closeable>();
    private final List<Boolean> activeWriters = new ArrayList<Boolean>();
    protected final ImmutableList.Builder<DataFileInfo> dataFileInfos = ImmutableList.builder();
    private final DeltaLakeParquetSchemaMapping parquetSchemaMapping;
    private long currentOpenWriters;

    public AbstractDeltaLakePageSink(TypeOperators typeOperators, List<DeltaLakeColumnHandle> inputColumns, List<String> originalPartitionColumns, PageIndexerFactory pageIndexerFactory, TrinoFileSystemFactory fileSystemFactory, int maxOpenWriters, JsonCodec<DataFileInfo> dataFileInfoCodec, Location tableLocation, Location outputPathDirectory, ConnectorSession session, DeltaLakeWriterStats stats, String trinoVersion, DeltaLakeParquetSchemaMapping parquetSchemaMapping) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.fileSystem = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null").create(session);
        this.maxOpenWriters = maxOpenWriters;
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.parquetSchemaMapping = Objects.requireNonNull(parquetSchemaMapping, "parquetSchemaMapping is null");
        int[] partitionColumnInputIndex = new int[originalPartitionColumns.size()];
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object[] partitionColumnTypes = new Type[originalPartitionColumns.size()];
        Object[] originalPartitionColumnNames = new String[originalPartitionColumns.size()];
        ImmutableList.Builder dataColumnHandles = ImmutableList.builder();
        ImmutableList.Builder dataColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumnNames = ImmutableList.builder();
        HashMap<String, Integer> toOriginalPartitionPositions = new HashMap<String, Integer>();
        int partitionColumnPosition = 0;
        for (String partitionColumnName : originalPartitionColumns) {
            toOriginalPartitionPositions.put(partitionColumnName, partitionColumnPosition++);
        }
        block6: for (int inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            DeltaLakeColumnHandle column = inputColumns.get(inputIndex);
            switch (column.getColumnType()) {
                case PARTITION_KEY: {
                    int partitionPosition = (Integer)toOriginalPartitionPositions.get(column.getColumnName());
                    partitionColumnInputIndex[partitionPosition] = inputIndex;
                    originalPartitionColumnNames[partitionPosition] = column.getColumnName();
                    partitionColumnTypes[partitionPosition] = column.getBaseType();
                    continue block6;
                }
                case REGULAR: {
                    Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column);
                    dataColumnHandles.add((Object)column);
                    dataColumnsInputIndex.add((Object)inputIndex);
                    dataColumnNames.add((Object)column.getBasePhysicalColumnName());
                    dataColumnTypes.add((Object)column.getBasePhysicalType());
                    continue block6;
                }
                case SYNTHESIZED: {
                    this.processSynthesizedColumn(column);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unexpected column type: " + String.valueOf((Object)column.getColumnType()));
                }
            }
        }
        this.partitionColumnsInputIndex = partitionColumnInputIndex;
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        this.originalPartitionColumnNames = ImmutableList.copyOf((Object[])originalPartitionColumnNames);
        this.dataColumnHandles = dataColumnHandles.build();
        this.partitionColumnTypes = ImmutableList.copyOf((Object[])partitionColumnTypes);
        this.dataColumnNames = dataColumnNames.build();
        this.dataColumnTypes = dataColumnTypes.build();
        this.pageIndexer = pageIndexerFactory.createPageIndexer(this.partitionColumnTypes);
        this.tableLocation = tableLocation;
        this.outputPathDirectory = outputPathDirectory;
        this.session = Objects.requireNonNull(session, "session is null");
        this.stats = stats;
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.targetMaxFileSize = DeltaLakeSessionProperties.getTargetMaxFileSize(session);
        this.idleWriterMinFileSize = DeltaLakeSessionProperties.getIdleWriterMinFileSize(session);
    }

    protected abstract void processSynthesizedColumn(DeltaLakeColumnHandle var1);

    protected abstract String getPathPrefix();

    protected abstract DataFileInfo.DataFileType getDataFileType();

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        for (int writerIndex = 0; writerIndex < this.writers.size(); ++writerIndex) {
            this.closeWriter(writerIndex);
        }
        this.writers.clear();
        ImmutableList dataFilesInfo = this.dataFileInfos.build();
        Collection result = (Collection)dataFilesInfo.stream().map(dataFileInfo -> Slices.wrappedBuffer((byte[])this.dataFileInfoCodec.toJsonBytes(dataFileInfo))).collect(ImmutableList.toImmutableList());
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.immediateFuture((Object)result));
    }

    public void abort() {
        List rollbackActions = (List)Streams.concat((Stream[])new Stream[]{this.writers.stream().filter(Objects::nonNull).map(writer -> writer::rollback), this.closedWriterRollbackActions.stream()}).collect(ImmutableList.toImmutableList());
        Throwable rollbackException = null;
        for (Closeable rollbackAction : rollbackActions) {
            try {
                rollbackAction.close();
            }
            catch (Throwable t) {
                if (rollbackException == null) {
                    rollbackException = new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error rolling back write to Delta Lake");
                }
                rollbackException.addSuppressed(t);
            }
        }
        if (rollbackException != null) {
            throw rollbackException;
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        Page chunk;
        for (int writeOffset = 0; writeOffset < page.getPositionCount(); writeOffset += chunk.getPositionCount()) {
            chunk = page.getRegion(writeOffset, Math.min(page.getPositionCount() - writeOffset, 4096));
            this.writePage(chunk);
        }
        return NOT_BLOCKED;
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            DeltaLakeWriter writer;
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify((positions.length == counts[index] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            Verify.verify(((writer = this.writers.get(index)) != null ? 1 : 0) != 0, (String)"Expected writer at index %s", (int)index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getMemoryUsage();
            writer.appendRows(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.memoryUsage += writer.getMemoryUsage() - currentMemory;
            this.activeWriters.set(index, true);
        }
    }

    public void closeIdleWriters() {
        for (int writerIndex = 0; writerIndex < this.writers.size(); ++writerIndex) {
            DeltaLakeWriter writer = this.writers.get(writerIndex);
            if (this.activeWriters.get(writerIndex).booleanValue() || writer == null || writer.getWrittenBytes() <= this.idleWriterMinFileSize) {
                this.activeWriters.set(writerIndex, false);
                continue;
            }
            LOG.debug("Closing writer %s with %s bytes written", new Object[]{writerIndex, writer.getWrittenBytes()});
            this.closeWriter(writerIndex);
        }
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = AbstractDeltaLakePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        int[] writerIndexes = this.pageIndexer.indexPage(partitionColumns);
        while (this.writers.size() <= this.pageIndexer.getMaxIndex()) {
            this.writers.add(null);
            this.activeWriters.add(false);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            DeltaLakeWriter deltaLakeWriter = this.writers.get(writerIndex);
            if (deltaLakeWriter != null) {
                if (deltaLakeWriter.getWrittenBytes() <= this.targetMaxFileSize) continue;
                this.closeWriter(writerIndex);
            }
            Location filePath = this.outputPathDirectory;
            List<String> partitionValues = AbstractDeltaLakePageSink.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
            Optional<String> partitionName = Optional.empty();
            if (!this.originalPartitionColumnNames.isEmpty()) {
                String partName = AbstractDeltaLakePageSink.makePartName(this.originalPartitionColumnNames, partitionValues);
                filePath = filePath.appendPath(partName);
                partitionName = Optional.of(partName);
            }
            String fileName = this.session.getQueryId() + "_" + String.valueOf(UUID.randomUUID());
            filePath = filePath.appendPath(fileName);
            ParquetFileWriter fileWriter = this.createParquetFileWriter(filePath);
            DeltaLakeWriter writer = new DeltaLakeWriter(fileWriter, this.tableLocation, this.getRelativeFilePath(partitionName, fileName), partitionValues, this.stats, this.dataColumnHandles, this.getDataFileType());
            this.writers.set(writerIndex, writer);
            ++this.currentOpenWriters;
            this.memoryUsage += writer.getMemoryUsage();
        }
        Verify.verify((this.writers.size() == this.pageIndexer.getMaxIndex() + 1 ? 1 : 0) != 0);
        if (this.currentOpenWriters > (long)this.maxOpenWriters) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Exceeded limit of %s open writers for partitions", this.maxOpenWriters));
        }
        return writerIndexes;
    }

    private String getRelativeFilePath(Optional<String> partitionName, String fileName) {
        return this.getPathPrefix() + partitionName.map(partition -> Locations.appendPath((String)partition, (String)fileName)).orElse(fileName);
    }

    protected void closeWriter(int writerIndex) {
        DeltaLakeWriter writer = this.writers.get(writerIndex);
        if (writer == null) {
            return;
        }
        long currentWritten = writer.getWrittenBytes();
        long currentMemory = writer.getMemoryUsage();
        this.closedWriterRollbackActions.add(writer.commit());
        this.writtenBytes += writer.getWrittenBytes() - currentWritten;
        this.memoryUsage -= currentMemory;
        this.writers.set(writerIndex, null);
        --this.currentOpenWriters;
        try {
            DataFileInfo dataFileInfo = writer.getDataFileInfo();
            this.dataFileInfos.add((Object)dataFileInfo);
        }
        catch (IOException e) {
            LOG.warn("exception '%s' while finishing write on %s", new Object[]{e, writer});
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error committing Parquet file to Delta Lake", (Throwable)e);
        }
    }

    private static String makePartName(List<String> partitionColumns, List<String> partitionValues) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(HiveUtil.escapePathName((String)partitionColumns.get(i)));
            name.append('=');
            name.append(HiveUtil.escapePathName((String)partitionValues.get(i)));
        }
        return name.toString();
    }

    public static List<String> createPartitionValues(List<Type> partitionColumnTypes, Page partitionColumns, int position) {
        return DeltaLakeWriteUtils.createPartitionValues(partitionColumnTypes, partitionColumns, position).stream().map(value -> value.equals("__HIVE_DEFAULT_PARTITION__") ? null : value).collect(Collectors.toList());
    }

    private ParquetFileWriter createParquetFileWriter(Location path) {
        ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxBlockSize(DeltaLakeSessionProperties.getParquetWriterBlockSize(this.session)).setMaxPageSize(DeltaLakeSessionProperties.getParquetWriterPageSize(this.session)).setMaxPageValueCount(DeltaLakeSessionProperties.getParquetWriterPageValueCount(this.session)).build();
        CompressionCodec compressionCodec = (CompressionCodec)DeltaLakeSessionProperties.getCompressionCodec(this.session).getParquetCompressionCodec().orElseThrow();
        try {
            Closeable rollbackAction = () -> this.fileSystem.deleteFile(path);
            List parquetTypes = (List)this.dataColumnTypes.stream().map(type -> DeltaLakeTypes.toParquetType(this.typeOperators, type)).collect(ImmutableList.toImmutableList());
            int[] identityMapping = new int[this.dataColumnTypes.size()];
            for (int i = 0; i < identityMapping.length; ++i) {
                identityMapping[i] = i;
            }
            return new ParquetFileWriter(this.fileSystem.newOutputFile(path), rollbackAction, parquetTypes, this.dataColumnNames, this.parquetSchemaMapping.messageType(), this.parquetSchemaMapping.primitiveTypes(), parquetWriterOptions, identityMapping, compressionCodec, this.trinoVersion, Optional.empty(), Optional.empty());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error creating Parquet file", (Throwable)e);
        }
    }

    private Page getDataPage(Page page) {
        Block[] blocks = new Block[this.dataColumnInputIndex.length];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }
}

