/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeCommitSummary {
    private final List<MetadataEntry> metadataUpdates;
    private final Optional<ProtocolEntry> protocol;
    private final Optional<Boolean> isBlindAppend;

    public DeltaLakeCommitSummary(List<DeltaLakeTransactionLogEntry> transactionLogEntries) {
        Objects.requireNonNull(transactionLogEntries, "transactionLogEntries is null");
        ImmutableList.Builder metadataUpdatesBuilder = ImmutableList.builder();
        Optional<Object> optionalProtocol = Optional.empty();
        Optional<CommitInfoEntry> optionalCommitInfo = Optional.empty();
        for (DeltaLakeTransactionLogEntry transactionLogEntry : transactionLogEntries) {
            if (transactionLogEntry.getMetaData() != null) {
                metadataUpdatesBuilder.add((Object)transactionLogEntry.getMetaData());
                continue;
            }
            if (transactionLogEntry.getProtocol() != null) {
                optionalProtocol = Optional.of(transactionLogEntry.getProtocol());
                continue;
            }
            if (transactionLogEntry.getCommitInfo() == null) continue;
            optionalCommitInfo = Optional.of(transactionLogEntry.getCommitInfo());
        }
        this.metadataUpdates = metadataUpdatesBuilder.build();
        this.protocol = optionalProtocol;
        this.isBlindAppend = optionalCommitInfo.flatMap(CommitInfoEntry::isBlindAppend);
    }

    public List<MetadataEntry> getMetadataUpdates() {
        return this.metadataUpdates;
    }

    public Optional<ProtocolEntry> getProtocol() {
        return this.protocol;
    }

    public Optional<Boolean> getIsBlindAppend() {
        return this.isBlindAppend;
    }
}

