/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.LocatedTableHandle;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DeltaLakeTableHandle
implements LocatedTableHandle {
    private final String schemaName;
    private final String tableName;
    private final boolean managed;
    private final String location;
    private final MetadataEntry metadataEntry;
    private final ProtocolEntry protocolEntry;
    private final TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint;
    private final TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint;
    private final Optional<WriteType> writeType;
    private final long readVersion;
    private final Optional<Set<DeltaLakeColumnHandle>> projectedColumns;
    private final Optional<List<DeltaLakeColumnHandle>> updatedColumns;
    private final Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns;
    private final Optional<AnalyzeHandle> analyzeHandle;
    private final boolean recordScannedFiles;
    private final boolean isOptimize;
    private final Optional<DataSize> maxScannedFileSize;
    private final Set<DeltaLakeColumnHandle> constraintColumns;

    @JsonCreator
    public DeltaLakeTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="managed") boolean managed, @JsonProperty(value="location") String location, @JsonProperty(value="metadataEntry") MetadataEntry metadataEntry, @JsonProperty(value="protocolEntry") ProtocolEntry protocolEntry, @JsonProperty(value="enforcedPartitionConstraint") TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint, @JsonProperty(value="nonPartitionConstraint") TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint, @JsonProperty(value="writeType") Optional<WriteType> writeType, @JsonProperty(value="projectedColumns") Optional<Set<DeltaLakeColumnHandle>> projectedColumns, @JsonProperty(value="updatedColumns") Optional<List<DeltaLakeColumnHandle>> updatedColumns, @JsonProperty(value="updateRowIdColumns") Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns, @JsonProperty(value="analyzeHandle") Optional<AnalyzeHandle> analyzeHandle, @JsonProperty(value="readVersion") long readVersion) {
        this(schemaName, tableName, managed, location, metadataEntry, protocolEntry, enforcedPartitionConstraint, nonPartitionConstraint, (Set<DeltaLakeColumnHandle>)ImmutableSet.of(), writeType, projectedColumns, updatedColumns, updateRowIdColumns, analyzeHandle, false, false, Optional.empty(), readVersion);
    }

    public DeltaLakeTableHandle(String schemaName, String tableName, boolean managed, String location, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint, TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint, Set<DeltaLakeColumnHandle> constraintColumns, Optional<WriteType> writeType, Optional<Set<DeltaLakeColumnHandle>> projectedColumns, Optional<List<DeltaLakeColumnHandle>> updatedColumns, Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns, Optional<AnalyzeHandle> analyzeHandle, boolean recordScannedFiles, boolean isOptimize, Optional<DataSize> maxScannedFileSize, long readVersion) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.managed = managed;
        this.location = Objects.requireNonNull(location, "location is null");
        this.metadataEntry = Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        this.protocolEntry = Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        this.enforcedPartitionConstraint = Objects.requireNonNull(enforcedPartitionConstraint, "enforcedPartitionConstraint is null");
        this.nonPartitionConstraint = Objects.requireNonNull(nonPartitionConstraint, "nonPartitionConstraint is null");
        this.writeType = Objects.requireNonNull(writeType, "writeType is null");
        Preconditions.checkArgument((updatedColumns.isPresent() == (writeType.isPresent() && writeType.get() == WriteType.UPDATE) ? 1 : 0) != 0);
        Preconditions.checkArgument((updateRowIdColumns.isPresent() == (writeType.isPresent() && writeType.get() == WriteType.UPDATE) ? 1 : 0) != 0);
        this.projectedColumns = Objects.requireNonNull(projectedColumns, "projectedColumns is null");
        this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
        this.updateRowIdColumns = Objects.requireNonNull(updateRowIdColumns, "rowIdColumns is null");
        this.analyzeHandle = Objects.requireNonNull(analyzeHandle, "analyzeHandle is null");
        this.recordScannedFiles = recordScannedFiles;
        this.isOptimize = isOptimize;
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
        this.readVersion = readVersion;
        this.constraintColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(constraintColumns, "constraintColumns is null"));
    }

    public DeltaLakeTableHandle withProjectedColumns(Set<DeltaLakeColumnHandle> projectedColumns) {
        return new DeltaLakeTableHandle(this.schemaName, this.tableName, this.managed, this.location, this.metadataEntry, this.protocolEntry, this.enforcedPartitionConstraint, this.nonPartitionConstraint, this.constraintColumns, this.writeType, Optional.of(projectedColumns), this.updatedColumns, this.updateRowIdColumns, this.analyzeHandle, this.recordScannedFiles, this.isOptimize, this.maxScannedFileSize, this.readVersion);
    }

    public DeltaLakeTableHandle forOptimize(boolean recordScannedFiles, DataSize maxScannedFileSize) {
        return new DeltaLakeTableHandle(this.schemaName, this.tableName, this.managed, this.location, this.metadataEntry, this.protocolEntry, this.enforcedPartitionConstraint, this.nonPartitionConstraint, this.constraintColumns, this.writeType, this.projectedColumns, this.updatedColumns, this.updateRowIdColumns, this.analyzeHandle, recordScannedFiles, true, Optional.of(maxScannedFileSize), this.readVersion);
    }

    @Override
    public SchemaTableName schemaTableName() {
        return this.getSchemaTableName();
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public boolean managed() {
        return this.isManaged();
    }

    @JsonProperty
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public String location() {
        return this.getLocation();
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public MetadataEntry getMetadataEntry() {
        return this.metadataEntry;
    }

    @JsonProperty
    public ProtocolEntry getProtocolEntry() {
        return this.protocolEntry;
    }

    @JsonProperty
    public TupleDomain<DeltaLakeColumnHandle> getEnforcedPartitionConstraint() {
        return this.enforcedPartitionConstraint;
    }

    @JsonProperty
    public TupleDomain<DeltaLakeColumnHandle> getNonPartitionConstraint() {
        return this.nonPartitionConstraint;
    }

    @JsonProperty
    public Optional<WriteType> getWriteType() {
        return this.writeType;
    }

    @JsonIgnore
    public Optional<Set<DeltaLakeColumnHandle>> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public Optional<List<DeltaLakeColumnHandle>> getUpdatedColumns() {
        return this.updatedColumns;
    }

    @JsonProperty
    public Optional<List<DeltaLakeColumnHandle>> getUpdateRowIdColumns() {
        return this.updateRowIdColumns;
    }

    @JsonProperty
    public Optional<AnalyzeHandle> getAnalyzeHandle() {
        return this.analyzeHandle;
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public boolean isOptimize() {
        return this.isOptimize;
    }

    @JsonIgnore
    public Optional<DataSize> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    @JsonIgnore
    public Set<DeltaLakeColumnHandle> getConstraintColumns() {
        return this.constraintColumns;
    }

    @JsonProperty
    public long getReadVersion() {
        return this.readVersion;
    }

    public String toString() {
        return this.getSchemaTableName().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeTableHandle that = (DeltaLakeTableHandle)o;
        return this.recordScannedFiles == that.recordScannedFiles && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.managed == that.managed && Objects.equals(this.location, that.location) && Objects.equals(this.metadataEntry, that.metadataEntry) && Objects.equals(this.protocolEntry, that.protocolEntry) && Objects.equals(this.enforcedPartitionConstraint, that.enforcedPartitionConstraint) && Objects.equals(this.nonPartitionConstraint, that.nonPartitionConstraint) && Objects.equals(this.writeType, that.writeType) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.updatedColumns, that.updatedColumns) && Objects.equals(this.updateRowIdColumns, that.updateRowIdColumns) && Objects.equals(this.analyzeHandle, that.analyzeHandle) && Objects.equals(this.isOptimize, that.isOptimize) && Objects.equals(this.maxScannedFileSize, that.maxScannedFileSize) && this.readVersion == that.readVersion;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.managed, this.location, this.metadataEntry, this.protocolEntry, this.enforcedPartitionConstraint, this.nonPartitionConstraint, this.writeType, this.projectedColumns, this.updatedColumns, this.updateRowIdColumns, this.analyzeHandle, this.recordScannedFiles, this.isOptimize, this.maxScannedFileSize, this.readVersion);
    }

    public static enum WriteType {
        UPDATE,
        DELETE;

    }
}

